/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.reader.view;

import java.io.File;
import java.util.ArrayList;
import org.luwrain.core.Lines;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.Document;
import org.luwrain.reader.ExtraInfo;
import org.luwrain.reader.Node;
import org.luwrain.reader.Paragraph;
import org.luwrain.reader.Run;
import org.luwrain.reader.TextRun;
import org.luwrain.reader.view.DefaultRowPartsBuilder;
import org.luwrain.reader.view.Iterator;
import org.luwrain.reader.view.Layout;
import org.luwrain.reader.view.NodeGeom;
import org.luwrain.reader.view.Row;
import org.luwrain.reader.view.RowPart;
import org.luwrain.util.LinesSaver;

public class View {
    public static final String DEFAULT_ITERATOR_INDEX_PROPERTY = "defaultiteratorindex";
    protected final Document doc;
    protected final Node root;
    protected final Paragraph[] paragraphs;
    protected final RowPart[] rowParts;
    protected final Row[] rows;
    protected final int lineCount;

    public View(Document doc, int width) {
        NullCheck.notNull((Object)doc, (String)"doc");
        this.doc = doc;
        this.root = doc.getRoot();
        NodeGeom geom = new NodeGeom();
        geom.calcWidth(this.root, width);
        DefaultRowPartsBuilder rowPartsBuilder = new DefaultRowPartsBuilder();
        rowPartsBuilder.onNode(this.root);
        this.rowParts = rowPartsBuilder.getRowParts();
        NullCheck.notNullItems((Object[])this.rowParts, (String)"rowParts");
        if (this.rowParts.length <= 0) {
            this.paragraphs = new Paragraph[0];
            this.rows = new Row[0];
            this.lineCount = 0;
            return;
        }
        this.paragraphs = rowPartsBuilder.getParagraphs();
        geom.calcHeight(this.root);
        geom.calcPosition(this.root);
        this.calcAbsRowNums(this.rowParts);
        this.rows = View.buildRows(this.rowParts);
        this.lineCount = this.calcRowsPosition(this.rows);
        this.setDefaultIteratorIndex();
    }

    public Layout createLayout() {
        Layout layout = new Layout(this.doc, this.root, this.rows, this.rowParts, this.paragraphs, this.lineCount);
        try {
            LinesSaver.saveLines((File)new File("/tmp/lines"), (Lines)layout);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return layout;
    }

    protected void calcAbsRowNums(RowPart[] parts) {
        NullCheck.notNullItems((Object[])parts, (String)"parts");
        if (parts.length < 1) {
            return;
        }
        RowPart first = parts[0];
        parts[0].absRowNum = 0;
        for (int i = 1; i < parts.length; ++i) {
            RowPart part = parts[i];
            if (!first.onTheSameRow(part)) {
                part.absRowNum = first.absRowNum + 1;
                first = part;
                continue;
            }
            part.absRowNum = first.absRowNum;
        }
    }

    protected static Row[] buildRows(RowPart[] parts) {
        int i;
        NullCheck.notNullItems((Object[])parts, (String)"parts");
        int rowCount = parts[parts.length - 1].absRowNum + 1;
        int[] fromParts = new int[rowCount];
        int[] toParts = new int[rowCount];
        for (i = 0; i < rowCount; ++i) {
            fromParts[i] = -1;
            toParts[i] = -1;
        }
        for (i = 0; i < parts.length; ++i) {
            int rowIndex = parts[i].absRowNum;
            if (fromParts[rowIndex] == -1 || toParts[rowIndex] > i) {
                fromParts[rowIndex] = i;
            }
            if (toParts[rowIndex] >= i + 1) continue;
            toParts[rowIndex] = i + 1;
        }
        Row[] rows = new Row[rowCount];
        for (int i2 = 0; i2 < rowCount; ++i2) {
            if (fromParts[i2] < 0 || toParts[i2] < 0) {
                throw new RuntimeException("Trying to create an empty row");
            }
            rows[i2] = new Row(parts, fromParts[i2], toParts[i2]);
        }
        return rows;
    }

    protected int calcRowsPosition(Row[] rows) {
        NullCheck.notNullItems((Object[])rows, (String)"rows");
        int maxLineNum = 0;
        int lastX = 0;
        int lastY = 0;
        for (Row r : rows) {
            Run run = r.getFirstRun();
            NullCheck.notNull((Object)run, (String)"run");
            Node parent = run.getParentNode();
            NullCheck.notNull((Object)parent, (String)"parent");
            if (parent instanceof Paragraph) {
                Paragraph paragraph = (Paragraph)parent;
                r.x = paragraph.getNodeX();
                r.y = paragraph.getNodeY() + r.getRelNum();
            } else {
                r.x = parent.getNodeX();
                r.y = parent.getNodeY();
            }
            lastX = r.x;
            lastY = r.y;
            if (r.y <= maxLineNum) continue;
            maxLineNum = r.y;
        }
        return maxLineNum + 1;
    }

    public Iterator getIterator() {
        return new Iterator(this);
    }

    public Iterator getIterator(int startingIndex) {
        return new Iterator(this, startingIndex);
    }

    Paragraph[] getParagraphs() {
        return (Paragraph[])this.paragraphs.clone();
    }

    Row[] getRows() {
        return (Row[])this.rows.clone();
    }

    RowPart[] getRowParts() {
        return (RowPart[])this.rowParts.clone();
    }

    private void setDefaultIteratorIndex() {
        ExtraInfo data;
        String id = this.doc.getProperty("startingref");
        if (id.isEmpty()) {
            return;
        }
        Log.debug((String)"doctree", (String)("preparing default iterator index for " + id));
        Iterator it = this.getIterator();
        while (it.canMoveNext() && ((data = it.getNode().extraInfo) == null || !data.hasIdInChain(id))) {
            Run[] runs = it.getRuns();
            TextRun foundRun = null;
            for (Run r : runs) {
                if (!(r instanceof TextRun)) continue;
                TextRun textRun = (TextRun)r;
                if (!textRun.extraInfo.hasIdInChain(id)) continue;
                foundRun = textRun;
            }
            if (foundRun != null) break;
            it.moveNext();
        }
        if (!it.canMoveNext()) {
            Log.debug((String)"doctree", (String)("no iterator position found for " + id));
            this.doc.setProperty(DEFAULT_ITERATOR_INDEX_PROPERTY, "");
            return;
        }
        this.doc.setProperty(DEFAULT_ITERATOR_INDEX_PROPERTY, "" + it.getIndex());
        Log.debug((String)"doctree", (String)("default iterator index set to " + it.getIndex()));
    }

    public static String[] getParagraphLines(Paragraph para, int width) {
        RowPart[] parts;
        NullCheck.notNull((Object)para, (String)"para");
        DefaultRowPartsBuilder builder = new DefaultRowPartsBuilder();
        builder.onNode(para, width);
        for (RowPart r : parts = builder.getRowParts()) {
            r.absRowNum = r.relRowNum;
        }
        Row[] rows = View.buildRows(parts);
        ArrayList<String> lines = new ArrayList<String>();
        for (Row r : rows) {
            lines.add(r.getText());
        }
        return lines.toArray(new String[lines.size()]);
    }
}

