/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.reader.view;

import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.Node;
import org.luwrain.reader.Paragraph;
import org.luwrain.reader.TableRow;
import org.luwrain.reader.view.NodeBase;
import org.luwrain.reader.view.RowPart;

final class NodeGeom {
    NodeGeom() {
    }

    void calcWidth(Node node, int recommended) {
        NullCheck.notNull((Object)node, (String)"node");
        Object[] subnodes = node.getSubnodes();
        NullCheck.notNullItems((Object[])subnodes, (String)"subnodes");
        if (node instanceof TableRow) {
            TableRow tableRow = (TableRow)node;
            int cellWidth = recommended - subnodes.length + 1 >= subnodes.length ? (recommended - subnodes.length + 1) / subnodes.length : 1;
            for (Object n : subnodes) {
                this.calcWidth((Node)n, cellWidth);
            }
            tableRow.width = 0;
            for (Object n : subnodes) {
                tableRow.width += ((Node)n).width;
            }
            tableRow.width += subnodes.length - 1;
            if (tableRow.width < recommended) {
                tableRow.width = recommended;
            }
            return;
        }
        node.width = recommended;
        for (Object n : subnodes) {
            this.calcWidth((Node)n, recommended);
            if (node.width >= ((Node)n).width) continue;
            node.width = ((Node)n).width;
        }
    }

    void calcHeight(Node node) {
        NullCheck.notNull((Object)node, (String)"node");
        if (node instanceof Paragraph) {
            Paragraph para = (Paragraph)node;
            if (para.getRowParts().length == 0) {
                Log.warning((String)"doctree", (String)"there is a paragraph without runs");
                para.setNodeHeight(0);
                return;
            }
            int maxRelRowNum = 0;
            for (RowPart p : para.getRowParts()) {
                if (p.relRowNum <= maxRelRowNum) continue;
                maxRelRowNum = p.relRowNum;
            }
            para.setNodeHeight(maxRelRowNum + 1);
            return;
        }
        Object[] subnodes = node.getSubnodes();
        NullCheck.notNullItems((Object[])subnodes, (String)"subnodes");
        if (node instanceof TableRow) {
            TableRow tableRow = (TableRow)node;
            for (Object n : subnodes) {
                this.calcHeight((Node)n);
            }
            tableRow.setNodeHeight(0);
            for (Object n : subnodes) {
                if (tableRow.getNodeHeight() >= ((NodeBase)n).getNodeHeight()) continue;
                tableRow.setNodeHeight(((NodeBase)n).getNodeHeight());
            }
            return;
        }
        for (Object n : subnodes) {
            this.calcHeight((Node)n);
        }
        int height = 0;
        for (Object n : subnodes) {
            height += ((NodeBase)n).getNodeHeight();
        }
        if (!node.allSubnodesSingleLine() && subnodes.length > 0) {
            height += subnodes.length - 1;
        }
        node.setNodeHeight(height);
    }

    void calcPosition(Node node) {
        NullCheck.notNull((Object)node, (String)"node");
        Object[] subnodes = node.getSubnodes();
        NullCheck.notNullItems((Object[])subnodes, (String)"subnodes");
        if (node.getType() == Node.Type.ROOT) {
            node.setNodeX(0);
            node.setNodeY(0);
        }
        int baseX = node.getNodeX();
        int baseY = node.getNodeY();
        if (node instanceof TableRow) {
            TableRow tableRow = (TableRow)node;
            int offset = 0;
            for (Object n : subnodes) {
                ((NodeBase)n).setNodeX(baseX + offset);
                offset += ((Node)n).width + 1;
                ((NodeBase)n).setNodeY(baseY);
                this.calcPosition((Node)n);
            }
            return;
        }
        int offset = 0;
        for (Object n : subnodes) {
            ((NodeBase)n).setNodeX(baseX);
            ((NodeBase)n).setNodeY(baseY + offset);
            offset += ((NodeBase)n).getNodeHeight();
            if (!node.allSubnodesSingleLine()) {
                ++offset;
            }
            this.calcPosition((Node)n);
        }
    }
}

