/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.reader.builders.html;

import java.util.LinkedList;
import java.util.Map;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.ExtraInfo;

class Base {
    static final String LOG_COMPONENT = "reader";
    private final LinkedList<ExtraInfo> extraInfoStack = new LinkedList();

    Base() {
    }

    protected void addExtraInfo(Element el) {
        NullCheck.notNull((Object)el, (String)"el");
        ExtraInfo info = new ExtraInfo();
        info.name = el.nodeName();
        Attributes attrs = el.attributes();
        if (attrs != null) {
            for (Attribute a : attrs.asList()) {
                String key = a.getKey();
                String value = a.getValue();
                if (key == null || key.isEmpty() || value == null) continue;
                info.attrs.put(key, value);
            }
        }
        info.parent = !this.extraInfoStack.isEmpty() ? this.extraInfoStack.getLast() : null;
        this.extraInfoStack.add(info);
    }

    protected void releaseExtraInfo() {
        if (!this.extraInfoStack.isEmpty()) {
            this.extraInfoStack.pollLast();
        }
    }

    protected ExtraInfo getCurrentExtraInfo() {
        return this.extraInfoStack.isEmpty() ? null : this.extraInfoStack.getLast();
    }

    protected static void collectMeta(Element el, Map<String, String> meta) {
        NullCheck.notNull((Object)el, (String)"el");
        NullCheck.notNull(meta, (String)"meta");
        if (el.nodeName().equals("meta")) {
            String name = el.attr("name");
            String content = el.attr("content");
            if (name != null && !name.isEmpty() && content != null) {
                meta.put(name, content);
            }
        }
        if (el.childNodes() != null) {
            for (Node n : el.childNodes()) {
                if (!(n instanceof Element)) continue;
                Base.collectMeta((Element)n, meta);
            }
        }
    }
}

