/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.reader;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.Node;

public class Document {
    public static final String DEFAULT_ITERATOR_INDEX_PROPERTY = "defaultiteratorindex";
    protected final Node root;
    protected final Properties props = new Properties();
    protected final String title;
    protected String[] hrefs;

    public Document(Node root) {
        NullCheck.notNull((Object)root, (String)"root");
        this.root = root;
        this.title = "";
        this.commit();
    }

    public Document(String title, Node root) {
        NullCheck.notNull((Object)root, (String)"root");
        NullCheck.notNull((Object)title, (String)"title");
        this.root = root;
        this.title = title;
        this.commit();
    }

    public void commit() {
        int deleted = 0;
        do {
            this.root.setEmptyMark();
        } while ((deleted = this.root.prune()) > 0);
        this.root.preprocess();
    }

    public String getTitle() {
        return this.title != null ? this.title : "";
    }

    public Node getRoot() {
        return this.root;
    }

    public void setProperty(String propName, String value) {
        NullCheck.notEmpty((Object)propName, (String)"propName");
        NullCheck.notNull((Object)value, (String)"value");
        this.props.setProperty(propName, value);
    }

    public String getProperty(String propName) {
        NullCheck.notEmpty((Object)propName, (String)"propName");
        String res = this.props.getProperty(propName);
        return res != null ? res : "";
    }

    public void setHrefs(String[] hrefs) {
        NullCheck.notNullItems((Object[])hrefs, (String)"hrefs");
        this.hrefs = hrefs;
    }

    public String[] getHrefs() {
        return this.hrefs;
    }

    public URL getUrl() {
        String value = this.getProperty("url");
        if (value.isEmpty()) {
            return null;
        }
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

