/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.reader.view;

import java.util.LinkedList;
import java.util.List;
import org.luwrain.controls.reader.view.BoundingInfo;
import org.luwrain.controls.reader.view.RowPart;
import org.luwrain.controls.reader.view.RowPartsSplitter;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.Node;
import org.luwrain.reader.Paragraph;
import org.luwrain.reader.Run;

final class TextExtractorFragment {
    private static final String LOG_COMPONENT = "document";
    private final int width;
    private final Run runFrom;
    private final Run runTo;
    private final int posFrom;
    private final int posTo;
    private boolean accepting = false;
    private final List<RowPart> parts = new LinkedList<RowPart>();

    TextExtractorFragment(int width, Run runFrom, int posFrom, Run runTo, int posTo) {
        NullCheck.notNull((Object)runFrom, (String)"runFrom");
        NullCheck.notNull((Object)runTo, (String)"runTo");
        if (width < 0) {
            throw new IllegalArgumentException("width (" + width + ") may not be negative");
        }
        this.width = width;
        this.runFrom = runFrom;
        this.posFrom = posFrom;
        this.runTo = runTo;
        this.posTo = posTo;
    }

    void onNode(Node node) {
    }

    private void onParagraph(Paragraph para) {
        NullCheck.notNull((Object)para, (String)"para");
        Run boundingRun1 = TextExtractorFragment.searchForRun(this.runFrom, para.getRuns());
        Run boundingRun2 = TextExtractorFragment.searchForRun(this.runTo, para.getRuns());
        if (!this.accepting && boundingRun1 == null && boundingRun2 == null) {
            return;
        }
        RowPartsSplitter splitter = new RowPartsSplitter();
        if (boundingRun1 == null && boundingRun2 == null) {
            for (Run r : para.getRuns()) {
                String text = r.text();
                NullCheck.notNull((Object)text, (String)"text");
                splitter.onRun(r, text, 0, text.length(), this.width);
            }
        } else {
            BoundingInfo boundingInfo = this.prepareBoundingInfo(para, boundingRun1, boundingRun2);
            boundingInfo.filter(para.getRuns(), (run, fromChar, toChar) -> {
                String text = run.text();
                NullCheck.notNull((Object)text, (String)"text");
                if (fromChar < 0 || fromChar >= text.length()) {
                    throw new RuntimeException("fromChar (" + fromChar + ") must be non-negative and less than " + text.length());
                }
                if (toChar < 0 || toChar >= text.length()) {
                    throw new RuntimeException("toChar (" + toChar + ") must be non-negative and less than " + text.length());
                }
                splitter.onRun(run, text, fromChar, toChar, this.width);
            });
        }
        if (splitter.res.isEmpty()) {
            return;
        }
        for (RowPart p : splitter.res) {
            this.parts.add(p);
        }
    }

    private BoundingInfo prepareBoundingInfo(Paragraph para, Run run1, Run run2) {
        throw new RuntimeException("Not implemented yet");
    }

    private static Run searchForRun(Run run, Run[] runs) {
        NullCheck.notNull((Object)run, (String)"run");
        NullCheck.notNullItems((Object[])runs, (String)"runs");
        for (Run r : runs) {
            if (r != run) continue;
            return run;
        }
        return null;
    }
}

