/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader.books;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Parser;
import org.luwrain.app.reader.books.Encoding;
import org.luwrain.core.NullCheck;

final class Utils {
    Utils() {
    }

    static String getDoctypeName(InputStream s) throws IOException {
        String res;
        Document doc = Jsoup.parse((InputStream)s, (String)"us-ascii", (String)"", (Parser)Parser.xmlParser());
        List nods = doc.childNodes();
        for (Node node : nods) {
            DocumentType documentType;
            if (!(node instanceof DocumentType) || (res = (documentType = (DocumentType)node).attr("name")) == null) continue;
            return res;
        }
        for (Node node : nods) {
            Element el;
            if (!(node instanceof Element) || (res = (el = (Element)node).tagName()) == null) continue;
            return res;
        }
        return "";
    }

    static String extractBaseContentType(String value) {
        NullCheck.notEmpty((Object)value, (String)"value");
        try {
            MimeType mime = new MimeType(value);
            String res = mime.getBaseType();
            return res != null ? res : "";
        }
        catch (MimeTypeParseException e) {
            return "";
        }
    }

    static String extractCharset(String value) {
        NullCheck.notEmpty((Object)value, (String)"value");
        try {
            MimeType mime = new MimeType(value);
            String res = mime.getParameter("charset");
            return res != null ? res : "";
        }
        catch (MimeTypeParseException e) {
            return "";
        }
    }

    static String extractHtmlCharset(File file) throws IOException {
        NullCheck.notNull((Object)file, (String)"file");
        String res = Encoding.getHtmlEncoding(file.toPath());
        if (res == null) {
            return "";
        }
        return res;
    }
}

