/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader.books;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.luwrain.app.reader.books.Book;
import org.luwrain.app.reader.books.Daisy2;
import org.luwrain.app.reader.books.SingleFileBook;
import org.luwrain.app.reader.books.UrlLoader;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.reader.Document;

public final class BookFactory {
    static final String LOG_COMPONENT = "reader";

    private Book initDaisy2(Luwrain luwrain, Document nccDoc) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)nccDoc, (String)"nccDoc");
        Daisy2 book = new Daisy2(luwrain);
        book.init(nccDoc);
        return book;
    }

    public Book newBook(Luwrain luwrain, String url) throws IOException {
        URL docUrl;
        UrlLoader loader = new UrlLoader(luwrain, new URL(url));
        UrlLoader.Result res = loader.load();
        Document doc = res.doc;
        try {
            docUrl = new URL(doc.getProperty("url"));
        }
        catch (MalformedURLException e) {
            Log.warning((String)LOG_COMPONENT, (String)("unable to extract the URL of the loaded document: " + e.getClass().getName() + ":" + e.getMessage()));
            return new SingleFileBook(luwrain, doc);
        }
        if (docUrl.getFile().toLowerCase().endsWith("/ncc.html")) {
            Log.debug((String)LOG_COMPONENT, (String)"opening the book as DAISY v2.2");
            return this.initDaisy2(luwrain, doc);
        }
        return new SingleFileBook(luwrain, res.doc);
    }
}

