/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader;

import org.luwrain.reader.ListItem;
import org.luwrain.reader.Node;
import org.luwrain.reader.Paragraph;
import org.luwrain.reader.Section;
import org.luwrain.reader.Table;
import org.luwrain.reader.TableCell;
import org.luwrain.reader.TableRow;
import org.luwrain.reader.Visitor;
import org.luwrain.reader.view.View;

class NarratorTextVisitor
implements Visitor {
    private final int paraPause = 500;
    private final StringBuilder builder = new StringBuilder();

    NarratorTextVisitor() {
    }

    @Override
    public void visitNode(Node node) {
    }

    @Override
    public void visit(ListItem node) {
        this.builder.append("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043f\u0438\u0441\u043a\u0430");
    }

    @Override
    public void visit(Paragraph para) {
        String[] lines = View.getParagraphLines(para, 80);
        if (lines.length < 1) {
            return;
        }
        for (String s : lines) {
            this.builder.append(s + "\n");
        }
        this.builder.append("#500\n\n");
    }

    @Override
    public void visit(Section node) {
        this.builder.append("\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a ");
    }

    @Override
    public void visit(TableCell node) {
    }

    @Override
    public void visit(Table node) {
    }

    @Override
    public void visit(TableRow node) {
    }

    public String toString() {
        return new String(this.builder);
    }
}

