/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.SortedMap;
import org.luwrain.app.reader.Strings;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.popups.Popups;

final class Conversations {
    public static final SortedMap<String, Charset> AVAILABLE_CHARSETS = Charset.availableCharsets();
    static final LinkedList<String> enteredUrls = new LinkedList();
    private final Luwrain luwrain;
    private final Strings strings;

    Conversations(Luwrain luwrain, Strings strings) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)strings, (String)"strings");
        this.luwrain = luwrain;
        this.strings = strings;
    }

    URL urlToOpen(String currentHref) {
        NullCheck.notNull((Object)currentHref, (String)"currentHref");
        String res = Popups.fixedEditList((Luwrain)this.luwrain, (String)this.strings.openUrlPopupName(), (String)this.strings.openUrlPopupPrefix(), (String)(currentHref.isEmpty() ? "http://" : currentHref), (String[])enteredUrls.toArray(new String[enteredUrls.size()]));
        if (res == null) {
            return null;
        }
        enteredUrls.add(res);
        try {
            return new URL(res);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    File fileToOpen() {
        return Popups.existingFile((Luwrain)this.luwrain, (String)this.strings.openPathPopupPrefix());
    }

    String newNote() {
        return Popups.textNotEmpty((Luwrain)this.luwrain, (String)this.strings.addNotePopupName(), (String)this.strings.addNotePopupPrefix(), (String)"");
    }

    boolean confirmLocalBookDeleting(String title) {
        NullCheck.notNull((Object)title, (String)"title");
        return Popups.confirmDefaultYes((Luwrain)this.luwrain, (String)this.strings.localRepoDeletePopupName(), (String)this.strings.localRepoDeletePopupText(title));
    }
}

