/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.reader;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.luwrain.app.reader.Settings;
import org.luwrain.core.NullCheck;
import org.luwrain.io.api.books.v1.Note;

final class Attributes {
    private final Gson gson = new Gson();
    private final Settings sett;
    private final Books books;

    Attributes(Settings sett) {
        NullCheck.notNull((Object)sett, (String)"sett");
        this.sett = sett;
        Books b = (Books)this.gson.fromJson(sett.getAttributes(""), Books.class);
        if (b == null) {
            b = new Books();
        }
        this.books = b;
        if (this.books.attrs == null) {
            this.books.attrs = new HashMap<String, Attrs>();
        }
    }

    List<Note> getBookNotes(String bookId) {
        NullCheck.notEmpty((Object)bookId, (String)"bookId");
        if (!this.books.attrs.containsKey(bookId)) {
            Attrs attrs = new Attrs();
            attrs.notes = new ArrayList<Note>();
            this.books.attrs.put(bookId, attrs);
            this.save();
            return attrs.notes;
        }
        Attrs a = this.books.attrs.get(bookId);
        List<Note> n = a.notes;
        a.notes = new ArrayList<Note>();
        if (n != null) {
            a.notes.addAll(n);
        }
        return a.notes;
    }

    void save() {
        this.sett.setAttributes(this.gson.toJson((Object)this.books));
    }

    private static final class Books {
        @SerializedName(value="attrs")
        Map<String, Attrs> attrs = null;

        private Books() {
        }
    }

    private static final class Attrs {
        @SerializedName(value="notes")
        List<Note> notes;

        private Attrs() {
        }
    }
}

