/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.api.mastodon;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Objects;
import lombok.NonNull;
import okhttp3.ResponseBody;
import org.luwrain.io.api.mastodon.Configuration;
import org.luwrain.io.api.mastodon.MastodonApiService;
import org.luwrain.io.api.mastodon.entity.AccountRegisterRequestBody;
import org.luwrain.io.api.mastodon.entity.Application;
import org.luwrain.io.api.mastodon.entity.ApplicationGetTokenRequestBody;
import org.luwrain.io.api.mastodon.entity.ApplicationRegisterRequestBody;
import org.luwrain.io.api.mastodon.entity.Token;
import retrofit2.Call;
import retrofit2.Response;

public class ApplicationClient {
    private Configuration config;
    private MastodonApiService apiService;
    private Application app;
    private Token appToken;
    Token accountToken;
    private File storage;

    private void initClientDir() {
        this.storage = new File(".storage");
        if (!this.storage.exists()) {
            System.out.println("created dir");
            this.storage.mkdirs();
        }
        System.out.println(this.storage.getAbsoluteFile());
    }

    public void loadApp() {
        try (BufferedReader br = new BufferedReader(new FileReader(".storage/secret.txt"));){
            try {
                this.app = (Application)new Gson().fromJson(br.readLine(), Application.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.appToken = (Token)new Gson().fromJson(br.readLine(), Token.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.accountToken = (Token)new Gson().fromJson(br.readLine(), Token.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    void writeApp() throws IOException {
        File storagePath = this.storage.getAbsoluteFile();
        PrintWriter out = new PrintWriter(new FileWriter(String.valueOf(storagePath) + "/secret.txt"));
        Gson gson = new Gson();
        out.println(gson.toJson((Object)this.app));
        out.println(gson.toJson((Object)this.appToken));
        out.println(gson.toJson((Object)this.accountToken));
        out.close();
    }

    boolean tryLoadFromFile() {
        try {
            this.loadApp();
            return true;
        }
        catch (Exception e) {
            System.out.println("Could not load app from file.");
            return false;
        }
    }

    public ApplicationClient(Configuration config) throws IOException {
        this.config = config;
        this.apiService = config.getService();
        if (!this.tryLoadFromFile()) {
            System.out.println("Register app");
            this.app = this.registerApplication();
        }
        this.initClientDir();
    }

    private Application registerApplication() throws IOException {
        ApplicationRegisterRequestBody requestBody = new ApplicationRegisterRequestBody();
        Call<Application> call = this.apiService.registerApp(requestBody);
        Response response = call.execute();
        if (response.isSuccessful()) {
            return (Application)response.body();
        }
        throw new IOException("Failed to register application");
    }

    private Token getAppToken() throws IOException {
        Call<Token> call = this.apiService.getToken(new ApplicationGetTokenRequestBody(this.app.getClientId(), this.app.getClientSecret()));
        Response response = call.execute();
        if (response.isSuccessful()) {
            return (Token)response.body();
        }
        throw new IOException("Failed to register application");
    }

    private void ensureAppToken() throws IOException {
        if (this.appToken == null) {
            this.appToken = this.getAppToken();
        }
    }

    private String getAuthHeader() throws IOException {
        this.ensureAppToken();
        return this.appToken.getTokenType() + " " + this.appToken.getAccessToken();
    }

    public void print() {
        System.out.println(this.app);
        System.out.println("Application" + String.valueOf(this.appToken));
    }

    boolean isValid() {
        try {
            this.ensureAppToken();
            String header = this.getAuthHeader();
            Call<Application> verifyCall = this.apiService.verifyApp(header);
            Response verifyResponse = verifyCall.execute();
            Application app = (Application)verifyResponse.body();
            return Objects.equals(this.app.getVapidKey(), app.getVapidKey());
        }
        catch (Exception e) {
            System.err.println("Could not verify token: " + e.getMessage());
            return false;
        }
    }

    public Token registerAccount(@NonNull String username, @NonNull String email, @NonNull String password, @NonNull Boolean agreement, String locale, String reason) throws IOException {
        AccountRegisterRequestBody body;
        String header;
        Call<Token> call;
        Response response;
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (email == null) {
            throw new NullPointerException("email is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        if (agreement == null) {
            throw new NullPointerException("agreement is marked non-null but is null");
        }
        if (locale == null || locale.isBlank()) {
            locale = "en-US";
        }
        if (reason == null) {
            reason = "";
        }
        if ((response = (call = this.apiService.registerAccount(header = this.getAuthHeader(), body = new AccountRegisterRequestBody(username, email, password, agreement, locale, reason))).execute()).isSuccessful()) {
            this.accountToken = (Token)response.body();
            this.writeApp();
            return this.accountToken;
        }
        System.out.println(response.code());
        System.out.println(response.errorBody().string());
        return null;
    }

    public boolean verifyAccount(Token token) throws IOException {
        Call<ResponseBody> call;
        Response response;
        if (token == null) {
            if (this.accountToken == null) {
                return false;
            }
            token = this.accountToken;
        }
        if ((response = (call = this.apiService.verifyAccount("Bearer " + token.getAccessToken())).execute()).isSuccessful()) {
            System.out.println(((ResponseBody)response.body()).string());
            return true;
        }
        System.out.println(response.errorBody().string());
        return false;
    }
}

