/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io.api.lsocial;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.luwrain.io.api.lsocial.QueryException;
import org.luwrain.io.api.lsocial.Response;

public class Query<E, R> {
    protected static final String CHARSET = "UTF-8";
    protected static Gson gson = new Gson();
    private final Type type;
    private final String baseUrl;
    private final String addr;
    Class<R> responseClass;
    protected Map<String, String> args = new HashMap<String, String>();

    public Query(Type type, String baseUrl, String addr, Class<R> responseClass) {
        this.type = Objects.requireNonNull(type, "type can't be null");
        this.baseUrl = Objects.requireNonNull(baseUrl, "baseUrl can't be null");
        this.addr = Objects.requireNonNull(addr, "addr can't be null");
        this.responseClass = Objects.requireNonNull(responseClass, "responseClass can't be null");
    }

    public R exec() throws IOException {
        switch (this.type) {
            case GET: {
                return this.execGet();
            }
            case POST: {
                return this.execPost();
            }
        }
        throw new IllegalArgumentException("Unknown query type: " + this.type.toString());
    }

    protected R execGet() throws IOException {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(this.doGet(this.addr), CHARSET));){
            Object object = gson.fromJson((Reader)r, this.responseClass);
            return (R)object;
        }
    }

    protected R execPost() throws IOException {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(this.doPost(this.addr, this.args), CHARSET));){
            Object object = gson.fromJson((Reader)r, this.responseClass);
            return (R)object;
        }
    }

    public E accessToken(String value) {
        this.args.put("atoken", Objects.requireNonNull(value, "value can't be null").trim());
        return (E)this;
    }

    protected InputStream doGet(String resource) throws IOException {
        return this.doGet(resource, this.args, true);
    }

    protected InputStream doGet(String resource, Map<String, String> args) throws IOException {
        return this.doGet(resource, args, true);
    }

    protected InputStream doGet(String resource, Map<String, String> args, boolean useEndpoint) throws IOException {
        if (resource == null || resource.isEmpty()) {
            throw new IllegalArgumentException("resource may not be empty");
        }
        Objects.requireNonNull(args, "args can't be empty");
        StringBuilder b = new StringBuilder();
        b.append(resource);
        b.append(this.encodeArgs(args, "?"));
        URL url = useEndpoint ? new URL(this.getBaseUrl(), new String(b)) : new URL(new String(b));
        HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
        httpCon.connect();
        if (httpCon.getResponseCode() == 200) {
            return httpCon.getInputStream();
        }
        throw this.buildException(url, httpCon);
    }

    protected InputStream doUpload(String resource, File file) throws IOException {
        URL url = new URL(resource);
        String charset = CHARSET;
        String boundary = Long.toHexString(System.currentTimeMillis());
        String CRLF = "\r\n";
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setDoOutput(true);
        con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        try (OutputStream output = con.getOutputStream();
             PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(output, charset), true);){
            writer.append("--" + boundary).append("\r\n");
            writer.append("Content-Disposition: form-data; name=\"data\"; filename=\"" + file.getName() + "\"").append("\r\n");
            writer.append("Content-Type: " + URLConnection.guessContentTypeFromName(file.getName())).append("\r\n");
            writer.append("Content-Transfer-Encoding: binary").append("\r\n");
            writer.append("\r\n").flush();
            Files.copy(file.toPath(), output);
            output.flush();
            writer.append("\r\n").flush();
            writer.append("--" + boundary + "--").append("\r\n").flush();
        }
        if (con.getResponseCode() == 200) {
            return con.getInputStream();
        }
        throw this.buildException(url, con);
    }

    protected InputStream doPost(String resource, Map<String, String> args) throws IOException {
        URL url = new URL(this.getBaseUrl(), resource + "?atoken=" + Objects.requireNonNull(args.get("atoken"), "No access token in the arguments map"));
        HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
        httpCon.setDoOutput(true);
        httpCon.setInstanceFollowRedirects(false);
        httpCon.setRequestMethod("POST");
        byte[] postData = this.encodeArgs(args, "").getBytes(StandardCharsets.UTF_8);
        int postDataLength = postData.length;
        httpCon.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        httpCon.setRequestProperty("charset", "utf-8");
        httpCon.setRequestProperty("Content-Length", Integer.toString(postDataLength));
        httpCon.setUseCaches(false);
        try (DataOutputStream w = new DataOutputStream(httpCon.getOutputStream());){
            w.write(postData);
            w.flush();
        }
        if (httpCon.getResponseCode() == 200) {
            return httpCon.getInputStream();
        }
        throw this.buildException(url, httpCon);
    }

    public InputStream doPost(String resource, String data) throws IOException {
        URL url = new URL(this.getBaseUrl(), resource);
        HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
        httpCon.setDoOutput(true);
        httpCon.setInstanceFollowRedirects(false);
        httpCon.setRequestMethod("POST");
        byte[] postData = data.getBytes(StandardCharsets.UTF_8);
        int postDataLength = postData.length;
        httpCon.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        httpCon.setRequestProperty("charset", "utf-8");
        httpCon.setRequestProperty("Content-Length", Integer.toString(postDataLength));
        httpCon.setUseCaches(false);
        try (DataOutputStream w = new DataOutputStream(httpCon.getOutputStream());){
            w.write(postData);
            w.flush();
        }
        if (httpCon.getResponseCode() == 200) {
            return httpCon.getInputStream();
        }
        throw this.buildException(url, httpCon);
    }

    void doPut(String resource) throws IOException {
        URL url = new URL(this.getBaseUrl(), resource);
        HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
        httpCon.setDoOutput(true);
        httpCon.setRequestMethod("PUT");
        OutputStreamWriter out = new OutputStreamWriter(httpCon.getOutputStream());
        out.write("FIXME");
        out.close();
        httpCon.getInputStream();
    }

    protected <R> R execGet(String path, Class<R> respClass) throws IOException {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(this.doGet(path), CHARSET));){
            Object object = gson.fromJson((Reader)r, respClass);
            return (R)object;
        }
    }

    String encodeArgs(Map<String, String> args, String prefix) {
        if (args.isEmpty()) {
            return "";
        }
        try {
            StringBuilder b = new StringBuilder();
            boolean first = true;
            for (Map.Entry<String, String> e : args.entrySet()) {
                b.append(first ? prefix : "&");
                first = false;
                b.append(URLEncoder.encode(e.getKey(), CHARSET)).append("=").append(URLEncoder.encode(e.getValue(), CHARSET));
            }
            return new String(b);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    URL getBaseUrl() throws IOException {
        return new URL(this.baseUrl);
    }

    QueryException buildException(URL url, HttpURLConnection con) throws IOException {
        int code = con.getResponseCode();
        if (code != 400 && code != 500) {
            return new QueryException("HTTP code: " + String.valueOf(code));
        }
        try (BufferedReader r = new BufferedReader(new InputStreamReader(con.getErrorStream(), CHARSET));){
            Response resp = (Response)gson.fromJson((Reader)r, Response.class);
            if (resp == null) {
                QueryException queryException = new QueryException("HTTP code: " + String.valueOf(code));
                return queryException;
            }
            QueryException queryException = new QueryException(code, resp);
            return queryException;
        }
    }

    public static enum Type {
        GET,
        POST;

    }
}

