/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.notepad;

import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.notepad.App;
import org.luwrain.app.notepad.Strings;
import org.luwrain.controls.FormArea;
import org.luwrain.core.Area;

public final class SettingsLayout
extends LayoutBase {
    private static final Logger log = LogManager.getLogger();
    final App app;
    final FormArea form;

    public SettingsLayout(App app, LayoutBase.ActionHandler close) {
        super((AppBase)app);
        this.app = app;
        Strings s = (Strings)app.getStrings();
        this.form = new FormArea(this.getControlContext(), s.settingsAreaName());
        this.form.addEdit("charsets", s.settingsFormCharsetList(), app.conf.getCharsets().stream().collect(Collectors.joining(", ")));
        this.form.addEdit("narrating-channel-name", s.settingsFormNarratingChannelName(), Objects.requireNonNullElse(app.conf.getNarratingChannelName(), ""));
        this.form.addEdit("narrating-channel-params", s.settingsFormNarratingChannelParams(), Objects.requireNonNullElse(app.conf.getNarratingChannelParams(), ""));
        this.form.addEdit("narrated-file-len", s.settingsFormNarratedFileLen(), String.valueOf(app.conf.getNarratedFileLen()));
        this.form.addEdit("narrating-speech-pitch", s.settingsFormNarratingSpeechPitch(), String.valueOf(app.conf.getNarratingSpeechPitch()));
        this.form.addEdit("narrating-speech-rate", s.settingsFormNarratingSpeechRate(), String.valueOf(app.conf.getNarratingSpeechRate()));
        this.form.addEdit("narrating-pause-duration", s.settingsFormNarratingPauseDuration(), String.valueOf(app.conf.getNarratingPauseDuration()));
        this.setAreaLayout((Area)this.form, null);
        this.setOkHandler(() -> {
            app.getLuwrain().saveConf((Object)app.conf);
            close.onAction();
            return true;
        });
        log.debug("Setting close handler");
        this.setCloseHandler(close);
    }
}

