/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.notepad;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import javax.sound.sampled.AudioFormat;
import org.apache.commons.io.IOUtils;
import org.luwrain.app.notepad.App;
import org.luwrain.app.notepad.Strings;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.speech.Channel;
import org.luwrain.util.SoundUtils;
import org.luwrain.util.StreamUtils;

class Narrating
implements Runnable {
    private static final String LOG_COMPONENT = "narrating";
    private final App app;
    private final Listener listener;
    private final File destDir;
    private final String[] text;
    private final Channel channel;
    private final String compressorCmd;
    boolean interrupting = false;
    private final long maxFragmentBytes;
    private File currentFile = null;
    private OutputStream stream = null;
    private int fragmentNum = 1;
    private AudioFormat chosenFormat = null;

    Narrating(App app, Listener listener, String[] text, File destDir, String compressorCmd, Channel channel) {
        NullCheck.notNull((Object)((Object)app), (String)"app");
        NullCheck.notNull((Object)listener, (String)"listener");
        NullCheck.notNullItems((Object[])text, (String)"text");
        NullCheck.notNull((Object)destDir, (String)"destDir");
        NullCheck.notNull((Object)compressorCmd, (String)"compressorCmd");
        NullCheck.notNull((Object)channel, (String)"channel");
        this.app = app;
        this.listener = listener;
        this.text = text;
        this.destDir = destDir;
        this.compressorCmd = compressorCmd;
        this.channel = channel;
        AudioFormat[] formats = channel.getSynthSupportedFormats();
        if (formats == null || formats.length == 0) {
            throw new RuntimeException("No supported audio formats");
        }
        this.chosenFormat = formats[0];
        Log.debug((String)LOG_COMPONENT, (String)("chosen format is " + this.chosenFormat.toString()));
        this.maxFragmentBytes = app.conf.getNarratedFileLen() > 0 ? (long)this.timeToBytes(app.conf.getNarratedFileLen() * 1000) : 0L;
        Log.debug((String)LOG_COMPONENT, (String)("max length of a fragment in bytes is " + String.valueOf(this.maxFragmentBytes)));
    }

    @Override
    public void run() {
        try {
            try {
                Log.debug((String)LOG_COMPONENT, (String)"starting narrating");
                this.openStream();
                for (int i = 0; i < this.text.length; ++i) {
                    if (this.interrupting) {
                        return;
                    }
                    String s = this.text[i];
                    if (!s.isEmpty()) {
                        this.onNewSent(this.app.getLuwrain().getSpeakableText(s, Luwrain.SpeakableTextType.NATURAL));
                    } else {
                        this.silence(this.app.conf.getNarratingPauseDuration());
                    }
                    this.listener.progressUpdate(i, this.text.length);
                }
            }
            finally {
                this.closeStream();
                if (this.interrupting) {
                    this.listener.cancelled();
                }
            }
            this.listener.done();
        }
        catch (Exception e) {
            this.app.getLuwrain().crash((Throwable)e);
        }
    }

    private void onNewSent(String s) throws IOException {
        if (this.maxFragmentBytes > 0L) {
            this.stream.flush();
            if (this.currentFile.length() > this.maxFragmentBytes) {
                this.closeStream();
                this.openStream();
            }
        }
        Channel.SyncParams p = new Channel.SyncParams();
        p.setRate(this.app.conf.getNarratingSpeechRate());
        p.setPitch(this.app.conf.getNarratingSpeechPitch());
        Log.debug((String)LOG_COMPONENT, (String)("Speaking '" + s + "'"));
        Channel.Result res = this.channel.synth(s, this.stream, this.chosenFormat, p, EnumSet.noneOf(Channel.Flags.class));
    }

    private void openStream() throws IOException {
        this.currentFile = File.createTempFile("lwrnarrating", ".dat");
        Log.debug((String)LOG_COMPONENT, (String)("created the temporary file " + this.currentFile.getAbsolutePath()));
        this.stream = new FileOutputStream(this.currentFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStream() throws IOException {
        if (this.stream == null || this.currentFile == null) {
            Log.debug((String)LOG_COMPONENT, (String)"nothing to close for narrating");
            return;
        }
        Log.debug((String)LOG_COMPONENT, (String)"closing stream");
        this.stream.flush();
        this.stream.close();
        this.stream = null;
        File targetFile = new File(this.destDir, this.getNextFragmentFileName() + ".wav");
        FileOutputStream targetStream = new FileOutputStream(targetFile);
        FileInputStream is = new FileInputStream(this.currentFile);
        try {
            Log.debug((String)LOG_COMPONENT, (String)("creating " + targetFile.getAbsolutePath()));
            byte[] header = SoundUtils.createWaveHeader((AudioFormat)this.chosenFormat, (int)((int)this.currentFile.length()));
            ((OutputStream)targetStream).write(header);
            IOUtils.copy((InputStream)is, (OutputStream)targetStream);
            targetStream.flush();
        }
        finally {
            ((InputStream)is).close();
            ((OutputStream)targetStream).close();
        }
        this.listener.writeMessage(((Strings)this.app.getStrings()).narratingFileWritten(targetFile.getAbsolutePath()));
        this.currentFile.delete();
        this.currentFile = null;
        Log.debug((String)LOG_COMPONENT, (String)"the temporary file deleted");
    }

    private void silence(int delayMsec) throws IOException {
        if (delayMsec <= 0) {
            return;
        }
        int numBytes = this.timeToBytes(delayMsec);
        byte[] buf = new byte[numBytes];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = 0;
        }
        StreamUtils.writeAllBytes((OutputStream)this.stream, (byte[])buf);
    }

    private int timeToBytes(int msec) {
        float value = this.chosenFormat.getSampleRate() * (float)this.chosenFormat.getSampleSizeInBits() * (float)this.chosenFormat.getChannels();
        value /= 8.0f;
        return (int)((value /= 1000.0f) * (float)msec);
    }

    private String getNextFragmentFileName() {
        String fileName = "" + this.fragmentNum;
        ++this.fragmentNum;
        while (fileName.length() < 3) {
            fileName = "0" + fileName;
        }
        return fileName;
    }

    static interface Listener {
        public void writeMessage(String var1);

        public void progressUpdate(int var1, int var2);

        public void done();

        public void cancelled();
    }
}

