/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.notepad;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.luwrain.app.notepad.App;
import org.luwrain.app.notepad.Strings;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Popup;
import org.luwrain.popups.Popups;
import org.luwrain.popups.YesNoPopup;

final class Conv {
    static final String charsets = "UTF-8:KOI8-R:windows-1251:IBM866:ISO-8859-5";
    private final Luwrain luwrain;
    private final Strings strings;
    private final Set<String> replaceExpHistory = new HashSet<String>();
    private final Set<String> replaceWithHistory = new HashSet<String>();

    Conv(App app) {
        this.luwrain = app.getLuwrain();
        this.strings = (Strings)app.getStrings();
    }

    File save(File currentFile) {
        return Popups.path((Luwrain)this.luwrain, (String)this.strings.savePopupName(), (String)this.strings.savePopupPrefix(), (File)currentFile, (fileToCheck, announce) -> {
            if (fileToCheck.exists() && fileToCheck.isDirectory()) {
                if (announce) {
                    this.luwrain.message(this.strings.enteredPathMayNotBeDir(fileToCheck.getAbsolutePath()), Luwrain.MessageType.ERROR);
                }
                return false;
            }
            return true;
        });
    }

    File open() {
        return Popups.existingFile((Luwrain)this.luwrain, (String)this.strings.openPopupName());
    }

    File narratingDestDir() {
        return Popups.existingDir((Luwrain)this.luwrain, (String)this.strings.narratingDestDirPopupPrefix());
    }

    String charset() {
        Object[] names = charsets.split(":", -1);
        Object res = Popups.fixedList((Luwrain)this.luwrain, (String)this.strings.charsetPopupPrefix(), (Object[])names);
        if (res == null) {
            return null;
        }
        return res.toString();
    }

    boolean rereadWithNewCharset(File file) {
        NullCheck.notNull((Object)file, (String)"file");
        return Popups.confirmDefaultYes((Luwrain)this.luwrain, (String)"\u041d\u043e\u0432\u0430\u044f \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0430", (String)("\u041f\u0435\u0440\u0435\u0447\u0438\u0442\u0430\u0442\u044c \u0444\u0430\u0439\u043b \"" + file.getAbsolutePath() + "\" \u0441 \u043d\u043e\u0432\u043e\u0439 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u043e\u0439?"));
    }

    UnsavedChangesRes unsavedChanges() {
        YesNoPopup popup = new YesNoPopup(this.luwrain, this.strings.saveChangesPopupName(), this.strings.saveChangesPopupQuestion(), true, Popups.DEFAULT_POPUP_FLAGS);
        this.luwrain.popup((Popup)popup);
        if (popup.wasCancelled()) {
            return UnsavedChangesRes.CANCEL;
        }
        return popup.result() ? UnsavedChangesRes.CONTINUE_SAVE : UnsavedChangesRes.CONTINUE_UNSAVED;
    }

    String replaceExp() {
        return Popups.editWithHistory((Luwrain)this.luwrain, (String)this.strings.replacePopupName(), (String)this.strings.replaceExpPopupPrefix(), (String)"", this.replaceExpHistory);
    }

    String replaceWith() {
        return Popups.editWithHistory((Luwrain)this.luwrain, (String)this.strings.replacePopupName(), (String)this.strings.replaceWithPopupPrefix(), (String)"", this.replaceWithHistory);
    }

    String correctionSuggestion(String[] options) {
        Object res = Popups.fixedList((Luwrain)this.luwrain, (String)this.strings.correctionSuggestionsPopupName(), (Object[])options);
        return res != null ? res.toString() : null;
    }

    static enum UnsavedChangesRes {
        CONTINUE_SAVE,
        CONTINUE_UNSAVED,
        CANCEL;

    }
}

