/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.notepad;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.FutureTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.notepad.Config;
import org.luwrain.app.notepad.Conv;
import org.luwrain.app.notepad.Hooks;
import org.luwrain.app.notepad.MainLayout;
import org.luwrain.app.notepad.Narrating;
import org.luwrain.app.notepad.NarratingLayout;
import org.luwrain.app.notepad.NarratingText;
import org.luwrain.app.notepad.Strings;
import org.luwrain.app.notepad.TextFiles;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.speech.Channel;

public final class App
extends AppBase<Strings> {
    private static final Logger log = LogManager.getLogger();
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String NATURAL_MODE_CORRECTOR_HOOK = "luwrain.notepad.mode.natural";
    private static final String PROGRAMMING_MODE_CORRECTOR_HOOK = "luwrain.notepad.mode.programming";
    File file = null;
    boolean modified = false;
    String charset = "UTF-8";
    String lineSeparator = System.lineSeparator();
    Mode mode = Mode.NONE;
    boolean speakIndent = false;
    Config conf = null;
    Conv conv = null;
    Hooks hooks = null;
    private FutureTask narratingTask = null;
    private Narrating narrating = null;
    private final String arg;
    private MainLayout mainLayout = null;
    private NarratingLayout narratingLayout = null;

    public App() {
        this(null);
    }

    public App(String arg) {
        super(Strings.class, "luwrain.notepad");
        this.arg = arg;
        this.setTabProcessing(false);
    }

    protected AreaLayout onAppInit() throws IOException {
        this.conf = (Config)this.getLuwrain().loadConf(Config.class);
        if (this.conf == null) {
            this.conf = new Config();
            this.getLuwrain().saveConf((Object)this.conf);
        }
        if (this.conf.getCharsets() == null) {
            this.conf.setCharsets(Arrays.asList(((Strings)this.getStrings()).defaultCharsetList().split(",", -1)).stream().map(e -> e.trim().toUpperCase()).toList());
        }
        this.conv = new Conv(this);
        this.hooks = new Hooks(this);
        this.mainLayout = new MainLayout(this);
        this.narratingLayout = new NarratingLayout(this, () -> {});
        this.setAppName(((Strings)this.getStrings()).appName());
        if (this.arg != null && !this.arg.isEmpty()) {
            this.file = new File(this.arg);
            if (this.file.exists() && !this.file.isDirectory()) {
                this.mainLayout.setText(TextFiles.read(this.file, this.charset));
            }
            this.modified = false;
            this.setAppName(this.file.getName());
        }
        return this.mainLayout.getAreaLayout();
    }

    void openLayout(AreaLayout layout) {
        NullCheck.notNull((Object)layout, (String)"layout");
        this.getLayout().setBasicLayout(layout);
    }

    boolean onSave() {
        if (!this.modified) {
            this.getLuwrain().message(((Strings)this.getStrings()).noModificationsToSave());
            return true;
        }
        if (this.file == null) {
            File f = this.conv.save(null);
            if (f == null) {
                return false;
            }
            this.file = f;
            this.mainLayout.onNewFile();
            this.setAppName(this.file.getName());
        }
        try {
            TextFiles.write(this.file, this.mainLayout.editArea.getTextAsList(), this.charset, this.lineSeparator);
        }
        catch (IOException e) {
            this.getLuwrain().crash((Throwable)e);
            return false;
        }
        this.modified = false;
        this.getLuwrain().message(((Strings)this.getStrings()).fileIsSaved(), Luwrain.MessageType.OK);
        return true;
    }

    boolean everythingSaved() {
        if (!this.modified) {
            return true;
        }
        switch (this.conv.unsavedChanges()) {
            case CONTINUE_SAVE: {
                return this.onSave();
            }
            case CONTINUE_UNSAVED: {
                return true;
            }
            case CANCEL: {
                return false;
            }
        }
        return false;
    }

    void activateMode(Mode mode) {
        switch (mode) {
            case NATURAL: {
                break;
            }
        }
    }

    boolean narrating(String[] text) {
        Channel channel;
        if (this.isBusy()) {
            return false;
        }
        NarratingText narratingText = new NarratingText();
        narratingText.split(text);
        if (narratingText.sents.isEmpty()) {
            this.getLuwrain().message(((Strings)this.getStrings()).noTextToSynth(), Luwrain.MessageType.ERROR);
            return true;
        }
        File destDir = this.conv.narratingDestDir();
        if (destDir == null) {
            return true;
        }
        try {
            channel = this.getLuwrain().loadSpeechChannel(this.conf.getNarratingChannelName(), this.conf.getNarratingChannelParams());
        }
        catch (Exception e) {
            this.getLuwrain().crash((Throwable)e);
            return true;
        }
        if (channel == null) {
            this.getLuwrain().message(((Strings)this.getStrings()).noChannelToSynth(this.conf.getNarratingChannelName()), Luwrain.MessageType.ERROR);
            return true;
        }
        log.trace("Narrating channel loaded: " + channel.getChannelName());
        NarratingLayout layout = new NarratingLayout(this, () -> this.cancelNarrating());
        this.narrating = new Narrating(this, layout, narratingText.sents.toArray(new String[narratingText.sents.size()]), destDir, new File(this.getLuwrain().getFileProperty("luwrain.dir.scripts"), "lwr-audio-compress").getAbsolutePath(), channel);
        this.narratingTask = new FutureTask<Object>(this.narrating, null);
        this.getLuwrain().executeBkg((Runnable)this.narratingTask);
        this.getLayout().setBasicLayout(layout.getLayout());
        return true;
    }

    private void cancelNarrating() {
        if (this.isBusy() && this.narrating != null) {
            this.narrating.interrupting = true;
            return;
        }
        this.narrating = null;
        this.narratingTask = null;
        this.setAreaLayout(this.mainLayout);
        this.getLuwrain().announceActiveArea();
    }

    void finishedNarrating() {
        this.narrating = null;
        this.narratingTask = null;
    }

    public boolean isBusy() {
        return this.narratingTask != null && !this.narratingTask.isDone();
    }

    public boolean onEscape() {
        this.closeApp();
        return true;
    }

    public void closeApp() {
        if (this.isBusy()) {
            this.getLuwrain().message(((Strings)this.getStrings()).cancelNarratingBeforeClosing(), Luwrain.MessageType.ERROR);
            return;
        }
        if (!this.everythingSaved()) {
            return;
        }
        super.closeApp();
    }

    static enum Mode {
        NONE,
        NATURAL,
        PROGRAMMING;

    }
}

