/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public final class StreamUtils {
    public static final int BUF_SIZE = 2048;

    public static long copyAllBytes(InputStream is, OutputStream os, Progress progress, Cancelling cancelling) throws IOException {
        Objects.requireNonNull(is, "is can't be null");
        Objects.requireNonNull(os, "os can't be null");
        long totalBytes = 0L;
        byte[] buf = new byte[2048];
        while (cancelling == null || !cancelling.cancelling()) {
            int length = is.read(buf);
            if (length == -1) {
                return totalBytes;
            }
            StreamUtils.writeAllBytes(os, buf, length);
            totalBytes += (long)length;
            if (progress == null) continue;
            progress.processed(length, totalBytes);
        }
        return totalBytes;
    }

    public static void writeAllBytes(OutputStream os, byte[] bytes, int numBytes) throws IOException {
        int numToWrite;
        Objects.requireNonNull(os, "os can't be null");
        Objects.requireNonNull(bytes, "bytes can't be null");
        if (numBytes < 0) {
            throw new IllegalArgumentException("numBytes (" + String.valueOf(numBytes) + ") can't be negative");
        }
        if (numBytes == 0) {
            return;
        }
        for (int pos = 0; pos < numBytes; pos += numToWrite) {
            int remaining = numBytes - pos;
            numToWrite = remaining > 2048 ? 2048 : remaining;
            os.write(bytes, pos, numToWrite);
        }
    }

    public static void writeAllBytes(OutputStream os, byte[] bytes) throws IOException {
        Objects.requireNonNull(os, "os can't be null");
        Objects.requireNonNull(bytes, "bytes can't be null");
        StreamUtils.writeAllBytes(os, bytes, bytes.length);
    }

    public static byte[] readAllBytes(InputStream is) throws IOException {
        Objects.requireNonNull(is, "is can't be null");
        byte[] buf = new byte[2048];
        ByteArrayOutputStream res = new ByteArrayOutputStream();
        int length = 0;
        do {
            if ((length = is.read(buf)) <= 0) continue;
            StreamUtils.writeAllBytes(res, buf, length);
        } while (length >= 0);
        return res.toByteArray();
    }

    public static interface Cancelling {
        public boolean cancelling();
    }

    public static interface Progress {
        public void processed(int var1, long var2);
    }
}

