/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.settings;

import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.SimpleArea;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.cpanel.ControlPanel;
import org.luwrain.cpanel.SectionArea;

final class Version
extends SimpleArea
implements SectionArea {
    private final ControlPanel controlPanel;
    private final Luwrain luwrain;

    Version(ControlPanel controlPanel) {
        super(new DefaultControlContext(controlPanel.getCoreInterface()), controlPanel.getCoreInterface().i18n().getStaticStr("CpVersion"));
        NullCheck.notNull((Object)controlPanel, (String)"controlPanel");
        this.controlPanel = controlPanel;
        this.luwrain = controlPanel.getCoreInterface();
        this.fillData();
    }

    private void fillData() {
        Runtime.getRuntime().gc();
        long memUsedBytes = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        String luwrainVersion = this.luwrain.i18n().getStaticStr("CpVersionLuwrain") + " " + this.luwrain.getProperty("luwrain.version") + " (" + System.getProperty("sun.arch.data.model") + " " + this.luwrain.i18n().getStaticStr("CpVersionLuwrainBits") + ")";
        String osVersion = this.luwrain.i18n().getStaticStr("CpVersionOs") + " " + System.getProperty("os.name") + " " + System.getProperty("os.version");
        String javaVersion = this.luwrain.i18n().getStaticStr("CpVersionJava") + " " + System.getProperty("java.version") + " (" + System.getProperty("java.vm.vendor") + ")";
        String memUsed = this.luwrain.i18n().getStaticStr("CpVersionMemUsed") + " " + memUsedBytes / 0x100000L + "M";
        this.update(lines -> {
            lines.add("");
            lines.add(luwrainVersion);
            lines.add(osVersion);
            lines.add(javaVersion);
            lines.add(memUsed);
            lines.add("");
        });
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.controlPanel.onInputEvent(event)) {
            return true;
        }
        return super.onInputEvent(event);
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.controlPanel.onSystemEvent(event)) {
            return true;
        }
        return super.onSystemEvent(event);
    }

    @Override
    public boolean saveSectionData() {
        return true;
    }

    static Version create(ControlPanel controlPanel) {
        NullCheck.notNull((Object)controlPanel, (String)"controlPanel");
        return new Version(controlPanel);
    }
}

