/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.ml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.jsoup.nodes.Node;
import org.luwrain.core.NullCheck;

final class JsNode
implements ProxyObject {
    private static String[] KEYS = new String[]{"childNodes"};
    private static final Set<String> KEYS_SET = new HashSet<String>(Arrays.asList(KEYS));
    private static final ProxyArray KEYS_ARRAY = ProxyArray.fromArray((Object[])KEYS);
    private final Node node;
    private final ProxyArray childNodes;

    JsNode(Node node) {
        NullCheck.notNull((Object)node, (String)"node");
        this.node = node;
        this.childNodes = this.buildChildNodesArray();
    }

    public Object getMember(String name) {
        NullCheck.notNull((Object)name, (String)"name");
        switch (name) {
            case "childNodes": {
                return this.childNodes;
            }
        }
        return null;
    }

    public boolean hasMember(String name) {
        return KEYS_SET.contains(name);
    }

    public Object getMemberKeys() {
        return KEYS_ARRAY;
    }

    public void putMember(String name, Value value) {
        throw new UnsupportedOperationException("The JsNode object doesn't support updating of its variables");
    }

    private ProxyArray buildChildNodesArray() {
        ArrayList<JsNode> res = new ArrayList<JsNode>();
        List childNodes = this.node.childNodes();
        if (childNodes != null) {
            for (Node c : childNodes) {
                res.add(new JsNode(c));
            }
        }
        return ProxyArray.fromArray((Object[])res.toArray(new JsNode[res.size()]));
    }
}

