/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.core;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.luwrain.core.NullCheck;
import org.luwrain.i18n.Lang;
import org.luwrain.script.ScriptUtils;

final class LangObj
implements ProxyObject {
    private static String[] KEYS = new String[]{"getSpecialNameOfChar"};
    private static final Set<String> KEYS_SET = new HashSet<String>(Arrays.asList(KEYS));
    private static final ProxyArray KEYS_ARRAY = ProxyArray.fromArray((Object[])KEYS);
    private final Lang lang;

    LangObj(Lang lang) {
        NullCheck.notNull((Object)lang, (String)"lang");
        this.lang = lang;
    }

    public Object getMember(String name) {
        NullCheck.notNull((Object)name, (String)"name");
        switch (name) {
            case "getSpecialNameOfChar": {
                return this::getSpecialNameOfChar;
            }
        }
        return null;
    }

    public boolean hasMember(String name) {
        return KEYS_SET.contains(name);
    }

    public Object getMemberKeys() {
        return KEYS_ARRAY;
    }

    public void putMember(String name, Value value) {
        throw new RuntimeException("The lang object doesn't support updating of its variables");
    }

    private String getSpecialNameOfChar(Value[] values) {
        if (!ScriptUtils.notNullAndLen(values, 1)) {
            return null;
        }
        if (!values[0].isString() || values[0].asString().length() != 1) {
            return null;
        }
        return this.lang.hasSpecialNameOfChar(values[0].asString().charAt(0));
    }
}

