/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.core;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.luwrain.core.Job;
import org.luwrain.core.JobLauncher;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.script.core.ScriptException;

final class JobImpl
implements JobLauncher {
    private final Luwrain luwrain;
    private final Object syncObj;
    private final String name;
    private final Value func;

    JobImpl(Luwrain luwrain, Object syncObj, String name, Value func) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)syncObj, (String)"syncObj");
        NullCheck.notEmpty((Object)name, (String)"name");
        NullCheck.notNull((Object)func, (String)"func");
        this.luwrain = luwrain;
        this.syncObj = syncObj;
        this.name = name;
        this.func = func;
    }

    @Override
    public String getExtObjName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Job launch(Job.Listener listener, String[] args, String dir) {
        NullCheck.notNull((Object)listener, (String)"listener");
        NullCheck.notNullItems((Object[])args, (String)"args");
        try {
            Instance instance = new Instance(listener);
            Object object = this.syncObj;
            synchronized (object) {
                Value res = this.func.execute(new Object[]{"RUN", instance, ProxyArray.fromArray((Object[])args)});
                if (res != null && res.isBoolean() && res.asBoolean()) {
                    return instance;
                }
                return null;
            }
        }
        catch (Throwable e) {
            this.luwrain.crash(e);
            return null;
        }
    }

    @Override
    public Set<JobLauncher.Flags> getJobFlags() {
        return EnumSet.noneOf(JobLauncher.Flags.class);
    }

    public final class Instance
    implements Job,
    ProxyObject {
        private final Job.Listener listener;
        private String name = "";

        Instance(Job.Listener listener) {
            NullCheck.notNull((Object)listener, (String)"listener");
            this.listener = listener;
        }

        @Override
        public String getInstanceName() {
            return this.name;
        }

        @Override
        public Job.Status getStatus() {
            return null;
        }

        @Override
        public int getExitCode() {
            return 0;
        }

        @Override
        public boolean isFinishedSuccessfully() {
            return true;
        }

        @Override
        public List<String> getInfo(String infoType) {
            return Arrays.asList(new String[0]);
        }

        @Override
        public void stop() {
        }

        public Object getMember(String name) {
            if (name == null) {
                return null;
            }
            switch (name) {
                case "name": {
                    return name;
                }
            }
            return null;
        }

        public boolean hasMember(String name) {
            switch (name) {
                case "name": {
                    return true;
                }
            }
            return false;
        }

        public Object getMemberKeys() {
            return new String[]{"name"};
        }

        public void putMember(String name, Value value) {
            if (name == null || name.trim().isEmpty() || value == null) {
                return;
            }
            switch (name) {
                case "name": {
                    if (value.isString() && !value.asString().trim().isEmpty() && this.name.isEmpty()) {
                        this.name = value.asString().trim();
                    }
                    return;
                }
            }
            throw new ScriptException("The command tool instance object doesn't have any member with the name '" + name + "'");
        }
    }
}

