/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.controls;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.luwrain.controls.SingleLineEdit;
import org.luwrain.script.ScriptUtils;

public final class SingleLineEditModelObj
implements ProxyObject {
    private static String[] KEYS = new String[]{"hotPoint", "line"};
    private static final Set<String> KEYS_SET = new HashSet<String>(Arrays.asList(KEYS));
    private static final ProxyArray KEYS_ARRAY = ProxyArray.fromArray((Object[])KEYS);
    protected final SingleLineEdit.Model model;

    public SingleLineEditModelObj(SingleLineEdit.Model model) {
        this.model = Objects.requireNonNull(model, "model can't be null");
    }

    public Object getMember(String name) {
        Objects.requireNonNull(name, "name can't be null");
        switch (name) {
            case "line": {
                return this.model.getLine();
            }
            case "hotPoint": {
                return this.model.getHotPointX();
            }
        }
        return null;
    }

    public void putMember(String name, Value value) {
        Objects.requireNonNull(name, "name can't be null");
        switch (name) {
            case "hotPoint": {
                int intValue = ScriptUtils.asInt(value);
                if (intValue < 0) {
                    throw new IllegalArgumentException("Value of a hot point can't be negative");
                }
                this.model.setHotPointX(intValue);
                return;
            }
            case "line": {
                this.model.setLine(Objects.requireNonNullElse(ScriptUtils.asString(value), ""));
                return;
            }
        }
        throw new IllegalArgumentException("No such property: " + name);
    }

    public boolean hasMember(String name) {
        return KEYS_SET.contains(name);
    }

    public Object getMemberKeys() {
        return KEYS_ARRAY;
    }
}

