/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.Proxy;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.luwrain.core.NullCheck;

public final class ScriptUtils {
    public static boolean isNull(Object obj) {
        if (obj == null || !(obj instanceof Value)) {
            return true;
        }
        Value value = (Value)obj;
        return value.isNull();
    }

    public static boolean notNull(Value[] values) {
        if (values == null) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null && !values[i].isNull()) continue;
            return false;
        }
        return true;
    }

    public static boolean notNullAndLen(Value[] values, int len) {
        if (!ScriptUtils.notNull(values)) {
            return false;
        }
        return values.length == len;
    }

    public static List<Object> getArrayItems(Object o) {
        if (o == null || !(o instanceof Value)) {
            return null;
        }
        Value value = (Value)o;
        if (!value.hasArrayElements()) {
            return null;
        }
        ArrayList<Object> res = new ArrayList<Object>();
        for (long i = 0L; i < value.getArraySize(); ++i) {
            res.add(value.getArrayElement(i));
        }
        return res;
    }

    public static Value getMember(Object obj, String name) {
        NullCheck.notEmpty((Object)name, (String)"name");
        if (obj == null || !(obj instanceof Value)) {
            return null;
        }
        Value value = (Value)obj;
        if (value.isNull() || !value.hasMembers()) {
            return null;
        }
        return value.getMember(name);
    }

    public static boolean isBoolean(Object obj) {
        if (obj == null || !(obj instanceof Value)) {
            return false;
        }
        Value value = (Value)obj;
        return !value.isNull() && value.isBoolean();
    }

    public static boolean asBoolean(Object obj) {
        if (obj == null || !(obj instanceof Value)) {
            return false;
        }
        Value value = (Value)obj;
        if (value.isNull() || !value.isBoolean()) {
            return false;
        }
        return value.asBoolean();
    }

    public static Number asNumber(Object obj) {
        if (obj == null || !(obj instanceof Value)) {
            return 0;
        }
        Value value = (Value)obj;
        if (value.isNull() || !value.isNumber()) {
            return null;
        }
        if (value.fitsInByte()) {
            return value.asByte();
        }
        if (value.fitsInShort()) {
            return value.asShort();
        }
        if (value.fitsInInt()) {
            return value.asInt();
        }
        if (value.fitsInLong()) {
            return value.asLong();
        }
        if (value.fitsInFloat()) {
            return Float.valueOf(value.asFloat());
        }
        return value.asDouble();
    }

    public static int asInt(Object obj) {
        if (obj == null || !(obj instanceof Value)) {
            return 0;
        }
        Value value = (Value)obj;
        if (value.isNull() || !value.isNumber()) {
            return 0;
        }
        return value.asInt();
    }

    public static String asString(Object obj) {
        if (obj == null || !(obj instanceof Value)) {
            return null;
        }
        Value value = (Value)obj;
        if (value.isNull() || !value.isString()) {
            return null;
        }
        return value.asString();
    }

    public static Object[] asArray(Object o) {
        if (o == null || !(o instanceof Value)) {
            return null;
        }
        Value v = (Value)o;
        if (v.isNull() || !v.hasArrayElements()) {
            return null;
        }
        Object[] res = new Object[(int)v.getArraySize()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = v.getArrayElement((long)i);
        }
        return res;
    }

    public static List<Object> asList(Object o) {
        if (o == null || !(o instanceof Value)) {
            return null;
        }
        Value v = (Value)o;
        if (v.isNull() || !v.hasArrayElements()) {
            return null;
        }
        ArrayList<Object> res = new ArrayList<Object>();
        long count = v.getArraySize();
        res.ensureCapacity((int)count);
        int i = 0;
        while ((long)i < count) {
            res.add(v.getArrayElement((long)i));
            ++i;
        }
        return res;
    }

    public static List<Object> asListOfNativeObjects(Object value) {
        List<Object> l = ScriptUtils.asList(value);
        if (l == null) {
            return null;
        }
        ArrayList<Object> res = new ArrayList<Object>();
        res.ensureCapacity(l.size());
        l.forEach(o -> {
            if (o instanceof Value) {
                Value v = (Value)o;
                if (v.isHostObject()) {
                    res.add(v.asHostObject());
                } else if (v.isString()) {
                    res.add(v.asString());
                } else if (v.isBoolean()) {
                    res.add(v.asBoolean());
                } else if (v.isNumber()) {
                    long num = v.asLong();
                    if (num <= Integer.MAX_VALUE && num >= Integer.MIN_VALUE) {
                        res.add(Long.valueOf(num).intValue());
                    }
                    res.add(num);
                }
            }
        });
        return res;
    }

    public static String[] asStringArray(Object o) {
        if (o == null || !(o instanceof Value)) {
            return null;
        }
        Value v = (Value)o;
        if (v.isNull() || !v.hasArrayElements()) {
            return null;
        }
        String[] res = new String[(int)v.getArraySize()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = v.getArrayElement((long)i).asString();
        }
        return res;
    }

    public static Proxy getArray(Object[] items) {
        NullCheck.notNullItems((Object[])items, (String)"items");
        return ProxyArray.fromArray((Object[])items);
    }

    public static <E> Proxy getArray(List<E> items) {
        Objects.requireNonNull(items, "items can't be null");
        return ProxyArray.fromArray((Object[])items.toArray(new Object[items.size()]));
    }

    public static <E> Proxy createEnumSet(Set<E> s) {
        Objects.requireNonNull(s, "s can't be null");
        ArrayList<String> res = new ArrayList<String>();
        for (E o : s) {
            res.add(o.toString().toLowerCase());
        }
        return ProxyArray.fromArray((Object[])res.toArray(new String[res.size()]));
    }

    public static Object getEnumItemByStr(Class enumClass, String itemName) {
        Objects.requireNonNull(enumClass, "enumClass can't be null");
        NullCheck.notEmpty((Object)itemName, (String)"itemName");
        EnumSet allItems = EnumSet.allOf(enumClass);
        for (Object s : allItems) {
            if (!s.toString().equals(itemName)) continue;
            return s;
        }
        return null;
    }

    public static Set getEnumByArrayObj(Class enumClass, Object arrayObj) {
        Objects.requireNonNull(enumClass, "enumClass can't be null");
        Objects.requireNonNull(arrayObj, "arrayObj can't be null");
        String[] items = ScriptUtils.asStringArray(arrayObj);
        if (items == null) {
            return null;
        }
        EnumSet<Object> res = EnumSet.noneOf(enumClass);
        for (String o : items) {
            Object enumItem;
            String str;
            if (o == null || (str = ScriptUtils.asString(o)) == null || (enumItem = ScriptUtils.getEnumItemByStr(enumClass, str.toUpperCase())) == null) continue;
            res.add(enumItem);
        }
        return res;
    }
}

