/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.HookContainer;
import org.luwrain.core.NullCheck;
import org.luwrain.script.HookException;
import org.luwrain.script.hooks.ChainOfResponsibilityHook;
import org.luwrain.script.hooks.CollectorHook;
import org.luwrain.script.hooks.NotificationHook;
import org.luwrain.script.hooks.PermissionHook;
import org.luwrain.script.hooks.ProviderHook;
import org.luwrain.script.hooks.TransformerHook;

public final class Hooks {
    private static final Logger log = LogManager.getLogger();
    public static final String ANNOUNCEMENT = "luwrain.announcement";
    public static final String AREA_CLEAR = "luwrain.area.clear";
    public static final String AREA_REGION_POINT_SET = "luwrain.area.region.point.set";
    public static final String CLIPBOARD_COPY_ALL = "luwrain.clipboard.copy.all";
    public static final String TEXT_INPUT_ML = "luwrain.edit.input";
    public static final String TEXT_INPUT_SL = "luwrain.text.input.single";
    public static final String STARTUP = "luwrain.startup";
    public static final String URL_OPEN = "luwrain.url.open";

    public static Object[] collector(HookContainer container, String hookName, Object[] args) {
        NullCheck.notNull((Object)container, (String)"container");
        NullCheck.notEmpty((Object)hookName, (String)"hookName");
        return new CollectorHook(container).run(hookName, args);
    }

    public static Object[] collectorForArrays(HookContainer container, String hookName, Object[] args) {
        NullCheck.notNull((Object)container, (String)"container");
        NullCheck.notEmpty((Object)hookName, (String)"hookName");
        return new CollectorHook(container).runForArrays(hookName, args);
    }

    public static boolean chainOfResponsibility(HookContainer container, String hookName, Object[] args) throws HookException {
        NullCheck.notNull((Object)container, (String)"container");
        NullCheck.notEmpty((Object)hookName, (String)"hookName");
        return new ChainOfResponsibilityHook(container).run(hookName, args);
    }

    public static boolean chainOfResponsibilityNoExc(HookContainer container, String hookName, Object[] args) {
        Objects.requireNonNull(container, "container can't be null");
        NullCheck.notEmpty((Object)hookName, (String)"hookName");
        log.debug("Running the " + hookName + " hook");
        try {
            return new ChainOfResponsibilityHook(container).run(hookName, args);
        }
        catch (Throwable ex) {
            log.error("The " + hookName + " hook thrown an exception", ex);
            return false;
        }
    }

    public static boolean permission(HookContainer container, String hookName, Object[] args) {
        NullCheck.notNull((Object)container, (String)"container");
        NullCheck.notEmpty((Object)hookName, (String)"hookName");
        return new PermissionHook(container).run(hookName, args);
    }

    public static Object provider(HookContainer container, String hookName, Object[] args) {
        NullCheck.notNull((Object)container, (String)"container");
        NullCheck.notEmpty((Object)hookName, (String)"hookName");
        return new ProviderHook(container).run(hookName, args);
    }

    public static boolean notification(HookContainer container, String hookName, Object[] args) {
        NullCheck.notNull((Object)container, (String)"container");
        NullCheck.notEmpty((Object)hookName, (String)"hookName");
        return new NotificationHook(container).run(hookName, args);
    }

    public static Object transformer(HookContainer container, String hookName, Object arg) {
        NullCheck.notNull((Object)container, (String)"container");
        NullCheck.notEmpty((Object)hookName, (String)"hookName");
        return new TransformerHook(container).run(hookName, arg);
    }
}

