/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.io;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Set;
import org.luwrain.controls.CommanderArea;
import org.luwrain.controls.CommanderUtils;
import org.luwrain.controls.ControlContext;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;

public final class CommanderUtilsFile {
    private static final String LOG_COMPONENT = "core";

    public static CommanderArea.Params<File> createParams(ControlContext context) {
        NullCheck.notNull((Object)context, (String)"context");
        CommanderArea.Params<File> params = new CommanderArea.Params<File>();
        params.context = context;
        params.model = new Model();
        params.appearance = new Appearance(context);
        params.filter = new CommanderUtils.AllEntriesFilter();
        params.comparator = new CommanderUtils.ByNameComparator();
        return params;
    }

    public static File prepareLocation(String path) {
        NullCheck.notEmpty((Object)path, (String)"path");
        return new File(path);
    }

    public static class Model
    implements CommanderArea.Model<File> {
        @Override
        public CommanderArea.EntryType getEntryType(File currentLocation, File entry) {
            NullCheck.notNull((Object)entry, (String)"entry");
            if (currentLocation.getParentFile() != null && entry.getAbsolutePath().equals(currentLocation.getParentFile().getAbsolutePath())) {
                return CommanderArea.EntryType.PARENT;
            }
            Path path = entry.toPath();
            if (Files.isSymbolicLink(path)) {
                return Files.isDirectory(path, new LinkOption[0]) ? CommanderArea.EntryType.SYMLINK_DIR : CommanderArea.EntryType.SYMLINK;
            }
            if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
                return CommanderArea.EntryType.DIR;
            }
            if (Files.isRegularFile(path, LinkOption.NOFOLLOW_LINKS)) {
                return CommanderArea.EntryType.REGULAR;
            }
            return CommanderArea.EntryType.SPECIAL;
        }

        public File[] getEntryChildren(File entry) {
            NullCheck.notNull((Object)entry, (String)"entry");
            try {
                File[] children = entry.listFiles();
                File parent = entry.getParentFile();
                if (parent == null) {
                    return children;
                }
                LinkedList<File> res = new LinkedList<File>();
                res.add(parent);
                for (File f : children) {
                    res.add(f);
                }
                return res.toArray(new File[res.size()]);
            }
            catch (Throwable e) {
                Log.error(CommanderUtilsFile.LOG_COMPONENT, "unable to get children of " + String.valueOf(entry) + ":" + e.getClass().getName() + ":" + e.getMessage());
                return null;
            }
        }

        @Override
        public File getEntryParent(File entry) {
            NullCheck.notNull((Object)entry, (String)"entry");
            return entry.getParentFile();
        }
    }

    public static class Appearance
    implements CommanderArea.Appearance<File> {
        protected final ControlContext context;

        public Appearance(ControlContext context) {
            NullCheck.notNull((Object)context, (String)"context");
            this.context = context;
        }

        @Override
        public String getCommanderName(File entry) {
            NullCheck.notNull((Object)entry, (String)"entry");
            return entry.getName();
        }

        @Override
        public void announceLocation(File entry) {
            NullCheck.notNull((Object)entry, (String)"entry");
            if (entry.getAbsolutePath().equals("/")) {
                this.context.say(this.context.getStaticStr("CommanderRoot"), Sounds.COMMANDER_LOCATION);
            } else {
                this.context.say(this.context.getSpeakableText(entry.getName(), Luwrain.SpeakableTextType.PROGRAMMING), Sounds.COMMANDER_LOCATION);
            }
        }

        @Override
        public String getEntryText(File entry, CommanderArea.EntryType type, boolean marked) {
            NullCheck.notNull((Object)entry, (String)"entry");
            if (type != null && type == CommanderArea.EntryType.PARENT) {
                return "..";
            }
            return entry.getName();
        }

        @Override
        public void announceEntry(File entry, CommanderArea.EntryType type, boolean marked) {
            NullCheck.notNull((Object)entry, (String)"entry");
            NullCheck.notNull((Object)((Object)type), (String)"type");
            String name = entry.getName();
            CommanderUtils.defaultEntryAnnouncement(this.context, name, type, marked);
        }
    }

    public static class Filter
    implements CommanderArea.Filter<File> {
        private final Set<Flags> flags;

        public Filter() {
            this.flags = EnumSet.noneOf(Flags.class);
        }

        public Filter(Set<Flags> flags) {
            NullCheck.notNull(flags, (String)"flags");
            this.flags = flags;
        }

        @Override
        public boolean commanderEntrySuits(File file) {
            NullCheck.notNull((Object)file, (String)"file");
            if (this.flags.contains((Object)Flags.NO_HIDDEN) && file.isHidden()) {
                return false;
            }
            return !this.flags.contains((Object)Flags.DIR_ONLY) || !file.isFile();
        }

        public static enum Flags {
            NO_HIDDEN,
            NO_NON_DIREXCLUDE_HIDDEN,
            DIR_ONLY;

        }
    }
}

