/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.luwrain.core.NullCheck;
import org.luwrain.core.util.RegistryExtractor;

public final class UserProfile {
    private final File dataDir;
    private final File destDir;
    private final String regVersion;
    private final String lang;

    public UserProfile(File dataDir, File destDir, String regVersion, String lang) {
        NullCheck.notNull((Object)dataDir, (String)"dataDir");
        NullCheck.notNull((Object)destDir, (String)"destDir");
        NullCheck.notEmpty((Object)regVersion, (String)"regVersion");
        NullCheck.notEmpty((Object)lang, (String)"lang");
        this.dataDir = dataDir;
        this.destDir = destDir;
        this.regVersion = regVersion;
        this.lang = lang;
    }

    public void userProfileReady() throws IOException {
        UserProfile.mkDirIfNotExists(this.destDir);
        UserProfile.mkDirIfNotExists(new File(this.destDir, "var"));
        UserProfile.mkDirIfNotExists(new File(this.destDir, "extensions"));
        UserProfile.mkDirIfNotExists(new File(this.destDir, "properties"));
        UserProfile.mkDirIfNotExists(new File(this.destDir, "sqlite"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registryDirReady() throws IOException {
        File registryDir = new File(this.destDir, "registry");
        UserProfile.mkDirIfNotExists(registryDir);
        File target = new File(registryDir, this.regVersion);
        if (target.isDirectory()) {
            return;
        }
        if (target.isFile()) {
            throw new IOException(target.getAbsolutePath() + " exists, but not a directory");
        }
        if (!target.mkdir()) {
            throw new IOException("Unable to create " + target.getAbsolutePath() + " needed for registry data");
        }
        RegistryExtractor extractor = new RegistryExtractor(target);
        InputStream commonIs = null;
        InputStream langIs = null;
        try {
            commonIs = new FileInputStream(new File(this.dataDir, "registry.dat"));
            langIs = new FileInputStream(new File(this.dataDir, "registry." + this.lang + ".dat"));
            extractor.extract(commonIs);
            extractor.extract(langIs);
        }
        finally {
            if (commonIs != null) {
                commonIs.close();
            }
            if (langIs != null) {
                langIs.close();
            }
        }
    }

    private static void mkDirIfNotExists(File file) throws IOException {
        if (file.isDirectory()) {
            return;
        }
        if (file.isFile()) {
            throw new IOException(file.getAbsolutePath() + " exists, but is a regular file");
        }
        if (file.exists()) {
            throw new IOException(file.getAbsolutePath() + " exists, but not a directory");
        }
        if (!file.mkdir()) {
            throw new IOException("Unable to create " + file.getAbsolutePath());
        }
    }
}

