/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core.properties;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.core.PropertiesProvider;

public final class PropertiesFiles
implements PropertiesProvider {
    private static final String LOG_COMPONENT = "properties";
    private final Properties props = new Properties();
    private PropertiesProvider.Listener listener = null;

    public void load(File propsDir) {
        NullCheck.notNull((Object)propsDir, (String)"propsDir");
        File[] systemPropertiesFiles = propsDir.listFiles();
        if (systemPropertiesFiles != null) {
            for (File f : systemPropertiesFiles) {
                if (f == null || f.isDirectory()) continue;
                this.readProps(f);
            }
        }
    }

    @Override
    public String getExtObjName() {
        return this.getClass().getName();
    }

    @Override
    public String[] getPropertiesRegex() {
        return new String[0];
    }

    @Override
    public Set<PropertiesProvider.Flags> getPropertyFlags(String propName) {
        return EnumSet.of(PropertiesProvider.Flags.PUBLIC);
    }

    @Override
    public String getProperty(String propName) {
        NullCheck.notEmpty((Object)propName, (String)"propName");
        return this.props.getProperty(propName);
    }

    @Override
    public boolean setProperty(String propName, String value) {
        NullCheck.notEmpty((Object)propName, (String)"propName");
        NullCheck.notNull((Object)value, (String)"value");
        return false;
    }

    @Override
    public void setListener(PropertiesProvider.Listener listener) {
        this.listener = listener;
    }

    private void readProps(File file) {
        NullCheck.notNull((Object)file, (String)"file");
        if (file.isDirectory() || !file.getName().endsWith(".properties")) {
            return;
        }
        try (FileInputStream s = new FileInputStream(file);){
            this.props.load(new InputStreamReader((InputStream)new BufferedInputStream(s), "UTF-8"));
        }
        catch (IOException e) {
            Log.error(LOG_COMPONENT, "unable to read properties file " + file.getAbsolutePath() + ":" + e.getClass().getName() + ":" + e.getMessage());
        }
    }
}

