/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core.properties;

import java.io.File;
import java.util.EnumSet;
import java.util.Set;
import org.luwrain.core.NullCheck;
import org.luwrain.core.PropertiesProvider;

public final class Basic
implements PropertiesProvider {
    private final File dataDir;
    private final File userDataDir;
    private final File userHomeDir;
    private PropertiesProvider.Listener listener = null;

    public Basic(File dataDir, File userDataDir, File userHomeDir) {
        NullCheck.notNull((Object)dataDir, (String)"dataDir");
        NullCheck.notNull((Object)userDataDir, (String)"userDataDir");
        NullCheck.notNull((Object)userHomeDir, (String)"userHomeDir");
        this.dataDir = dataDir;
        this.userDataDir = userDataDir;
        this.userHomeDir = userHomeDir;
    }

    @Override
    public String getExtObjName() {
        return this.getClass().getName();
    }

    @Override
    public String[] getPropertiesRegex() {
        return new String[0];
    }

    @Override
    public Set<PropertiesProvider.Flags> getPropertyFlags(String propName) {
        NullCheck.notEmpty((Object)propName, (String)"propName");
        String value = this.getProperty(propName);
        if (value != null) {
            return EnumSet.of(PropertiesProvider.Flags.PUBLIC, PropertiesProvider.Flags.FILE);
        }
        return null;
    }

    @Override
    public String getProperty(String propName) {
        NullCheck.notNull((Object)propName, (String)"propName");
        switch (propName) {
            case "luwrain.dir.userhome": {
                return this.userHomeDir.getAbsolutePath();
            }
            case "luwrain.dir.data": {
                return this.dataDir.getAbsolutePath();
            }
            case "luwrain.dir.scripts": {
                return new File(this.dataDir, "scripts").getAbsolutePath();
            }
            case "luwrain.dir.js": {
                return new File(this.dataDir, "js").getAbsolutePath();
            }
            case "luwrain.dir.textext": {
                return new File(this.dataDir, "text").getAbsolutePath();
            }
            case "luwrain.dir.properties": {
                return new File(this.dataDir, "properties").getAbsolutePath();
            }
            case "luwrain.dir.sounds": {
                return new File(this.dataDir, "sounds").getAbsolutePath();
            }
            case "luwrain.dir.userdata": {
                return this.userDataDir.getAbsolutePath();
            }
            case "luwrain.dir.appdata": {
                return new File(this.userDataDir, "var").getAbsolutePath();
            }
            case "luwrain.dir.packs": {
                return new File(this.userDataDir, "extensions").getAbsolutePath();
            }
        }
        return null;
    }

    @Override
    public boolean setProperty(String propName, String value) {
        NullCheck.notEmpty((Object)propName, (String)"propName");
        NullCheck.notNull((Object)value, (String)"value");
        return false;
    }

    @Override
    public void setListener(PropertiesProvider.Listener listener) {
        this.listener = listener;
    }
}

