/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core.events.resp;

import org.luwrain.core.EventResponse;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.Suggestions;
import org.luwrain.core.events.resp.Base;
import org.luwrain.io.json.CommonSettings;

public class ListItemResponse
implements EventResponse {
    protected final Sounds sound;
    protected final String text;
    protected final Suggestions suggestion;

    public ListItemResponse(Sounds sound, String text, Suggestions suggestion) {
        NullCheck.notNull((Object)text, (String)"text");
        this.sound = sound;
        this.text = text;
        this.suggestion = suggestion;
    }

    @Override
    public void announce(Luwrain luwrain, EventResponse.Speech speech, CommonSettings sett) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)speech, (String)"speech");
        if (this.sound != null) {
            luwrain.playSound(this.sound);
        } else {
            luwrain.playSound(Sounds.LIST_ITEM);
        }
        if (this.suggestion == null) {
            speech.speak(new String[]{this.text});
            return;
        }
        String suggestionText = Base.getSuggestionText(this.suggestion, luwrain.i18n());
        if (suggestionText != null) {
            speech.speak(new String[]{this.text, suggestionText});
        } else {
            speech.speak(new String[]{this.text});
        }
    }
}

