/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core.events.resp;

import java.util.Objects;
import org.luwrain.core.EventResponse;
import org.luwrain.core.Hint;
import org.luwrain.core.Luwrain;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.resp.Base;
import org.luwrain.io.json.CommonSettings;

public class HintResponse
implements EventResponse {
    protected final Hint hint;
    protected final String text;

    public HintResponse(Hint hint, String text) {
        Objects.requireNonNull(hint, "hint can't be null");
        this.hint = hint;
        this.text = text;
    }

    public HintResponse(Hint hint) {
        this(hint, null);
    }

    @Override
    public void announce(Luwrain luwrain, EventResponse.Speech speech, CommonSettings sett) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        Objects.requireNonNull(speech, "speech can't be null");
        String hintText = this.text == null ? Base.getTextForHint(luwrain, this.hint) : this.text;
        Sounds sound = Base.getSoundForHint(this.hint);
        if (sett.isHintsSounds() && sound != null) {
            luwrain.playSound(sound);
        }
        if (sett.isHintsText() && hintText != null && !hintText.trim().isEmpty()) {
            luwrain.speak(hintText, -25);
        } else {
            luwrain.silence();
        }
    }
}

