/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import org.luwrain.core.NullCheck;

public final class UniRefInfo
implements Comparable {
    private final boolean available;
    private final String value;
    private final String type;
    private final String addr;
    private final String title;

    public UniRefInfo(String value) {
        NullCheck.notNull((Object)value, (String)"value");
        this.available = false;
        this.value = value;
        this.type = "";
        this.addr = "";
        this.title = "";
    }

    public UniRefInfo(String value, String type, String addr, String title) {
        NullCheck.notNull((Object)value, (String)"value");
        NullCheck.notNull((Object)type, (String)"type");
        NullCheck.notNull((Object)addr, (String)"addr");
        NullCheck.notNull((Object)title, (String)"title");
        this.available = true;
        this.value = value;
        this.type = type;
        this.addr = addr;
        this.title = title;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public String getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public String getAddr() {
        return this.addr;
    }

    public String getTitle() {
        return this.title;
    }

    public String toString() {
        if (!this.available) {
            return this.value;
        }
        return this.title;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof UniRefInfo)) {
            return false;
        }
        UniRefInfo uniRef = (UniRefInfo)o;
        return this.value.equals(uniRef.getValue());
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof UniRefInfo)) {
            return 0;
        }
        UniRefInfo uniRef = (UniRefInfo)o;
        return this.value.compareTo(uniRef.getValue());
    }

    public static String makeValue(String type, String addr) {
        NullCheck.notEmpty((Object)type, (String)"type");
        NullCheck.notNull((Object)addr, (String)"addr");
        if (type.indexOf(":") >= 0) {
            throw new IllegalArgumentException("type (" + type + ") can't contain the ':' character");
        }
        StringBuilder b = new StringBuilder();
        b.append(type).append(":").append(addr);
        return new String(b);
    }
}

