/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.Args;
import org.luwrain.core.Config;
import org.luwrain.core.Configs;
import org.luwrain.core.Core;
import org.luwrain.core.InitResult;
import org.luwrain.core.Interaction;
import org.luwrain.core.JniLoader;
import org.luwrain.core.OperatingSystem;
import org.luwrain.io.json.CommonSettings;

final class Launch {
    private static final Logger log = LogManager.getLogger();
    private final Args args;
    private final Config conf = new Config();
    private final ClassLoader classLoader;
    private OperatingSystem os = null;
    private Interaction interaction = null;

    Launch(Args args, File appDir, File dataDir, File userDataDir, File userHomeDir, String lang) {
        this.args = Objects.requireNonNull(args, "args can't be null");
        this.conf.setAppDir(Objects.requireNonNull(appDir, "appDir can't be null"));
        this.conf.setDataDir(Objects.requireNonNull(dataDir, "dataDir can't be null"));
        this.conf.setUserDataDir(Objects.requireNonNull(userDataDir, "userDataDir"));
        this.conf.setUserHomeDir(Objects.requireNonNull(userHomeDir, "userHomeDir can't be null"));
        this.conf.setJsDir(new File(appDir, "js"));
        this.conf.setPacksDir(new File(userDataDir, "packs"));
        this.conf.setUserVarDir(new File(userDataDir, "var"));
        this.conf.setSoundsDir(new File(dataDir, "sounds"));
        log.debug("starting LUWRAIN: Java " + System.getProperty("java.version") + " by " + System.getProperty("java.vendor") + " (installed in " + System.getProperty("java.home") + ")");
        new JniLoader().autoload(this.getClass().getClassLoader());
        if (lang.isEmpty()) {
            log.fatal("unable to select a language to use");
            System.exit(1);
        }
        this.conf.setLang(lang);
        this.conf.setArgs(args);
        this.classLoader = this.getClass().getClassLoader();
        this.conf.setCoreClassLoader(this.classLoader);
    }

    void run() {
        try {
            this.conf.setConfigs(configs);
            try (Configs configs = new Configs(new File(this.conf.getUserDataDir(), "conf"));){
                try {
                    this.initOs();
                    this.conf.setOperatingSystem(this.os);
                    this.initInteraction();
                    this.conf.setInteraction(this.interaction);
                    this.initTimeZone();
                    new Core(this.conf).run();
                }
                finally {
                    if (this.interaction != null) {
                        this.interaction.close();
                    }
                }
            }
            System.exit(0);
        }
        catch (Throwable e) {
            log.fatal("Fatal LUWRAIN error , exiting", e);
            System.err.println();
            System.err.println("FATAL: " + e.getMessage());
            System.exit(1);
        }
    }

    private void initOs() {
        log.trace("Loading operating system");
        ArrayList<OperatingSystem> instances = new ArrayList<OperatingSystem>();
        ServiceLoader<OperatingSystem> interactionLoader = ServiceLoader.load(OperatingSystem.class);
        for (OperatingSystem instance : interactionLoader) {
            log.trace("Found operating system instance of class " + instance.getClass().getName());
            instances.add(instance);
        }
        if (instances.isEmpty()) {
            throw new IllegalStateException("No operating system instances");
        }
        if (instances.size() > 1) {
            if (this.args.os == null || this.args.os.trim().isEmpty()) {
                throw new IllegalStateException("There are " + instances.size() + " operating system instances, please explicitly choose which one to use");
            }
            for (OperatingSystem i : instances) {
                if (!i.getClass().getName().equals(this.args.os.trim()) && !i.getClass().getSimpleName().toUpperCase().equals(this.args.os.trim().toUpperCase())) continue;
                this.os = i;
                break;
            }
            if (this.os == null) {
                throw new IllegalStateException("Unable to find an OS interface with name '" + this.args.os.trim() + "'");
            }
        } else {
            this.os = (OperatingSystem)instances.get(0);
        }
        log.trace("Using operating system from the class " + this.os.getClass().getName());
        InitResult initRes = this.os.init(null);
        if (!(initRes != null && initRes.isOk() || initRes == null)) {
            throw new RuntimeException("Unable to initialize operating system");
        }
    }

    private void initInteraction() {
        log.trace("Loading interaction");
        ArrayList<Interaction> instances = new ArrayList<Interaction>();
        ServiceLoader<Interaction> interactionLoader = ServiceLoader.load(Interaction.class);
        for (Interaction instance : interactionLoader) {
            log.trace("Found interaction instance of class " + instance.getClass().getName());
            instances.add(instance);
        }
        if (instances.isEmpty()) {
            throw new IllegalStateException("No interaction instances");
        }
        if (instances.size() > 1) {
            throw new IllegalStateException("There are " + instances.size() + " interaction instances, please explicitly choose which to use");
        }
        this.interaction = (Interaction)instances.get(0);
        log.trace("Using interaction from the class " + this.interaction.getClass().getName());
        Interaction.Params params = this.conf.getConfigs().load(Interaction.Params.class);
        if (params == null) {
            log.trace("No interaction params in configs, using default");
            params = new Interaction.Params();
            this.conf.getConfigs().save(params);
        }
        if (!this.interaction.init(params, this.os)) {
            throw new RuntimeException("Interaction init failed");
        }
    }

    private void initTimeZone() {
        CommonSettings sett = this.conf.getConfigs().load(CommonSettings.class);
        if (sett == null || Objects.requireNonNullElse(sett.getTimeZone(), "").trim().isEmpty()) {
            log.trace("No time zone information, skipping setting the time zone");
            return;
        }
        String value = sett.getTimeZone().trim();
        log.trace("Setting the time zone  " + value);
        TimeZone timeZone = TimeZone.getTimeZone(value);
        if (timeZone != null) {
            TimeZone.setDefault(timeZone);
            return;
        }
        log.warn("time zone " + value + " is unknown");
    }
}

