/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.net.URI;
import java.util.Objects;
import org.luwrain.core.Starter;
import org.luwrain.core.StarterCategory;

public class DefaultStarter
implements Starter {
    protected final String name;
    protected final StarterCategory category;
    protected final URI uri;

    public DefaultStarter(String name, URI uri, StarterCategory category) {
        this.name = Objects.requireNonNull(name, "name can't be null");
        this.uri = Objects.requireNonNull(uri, "yuri can't be null");
        this.category = Objects.requireNonNull(category, "category can't be null");
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name can't be empty");
        }
    }

    public DefaultStarter(URI uri, StarterCategory category) {
        this("Starter " + uri.toString(), uri, category);
    }

    public DefaultStarter(String uri, StarterCategory category) {
        this(URI.create(uri), category);
    }

    @Override
    public String getExtObjName() {
        return this.name;
    }

    @Override
    public StarterCategory getCategory() {
        return this.category;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }
}

