/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.luwrain.core.ConfigUpdate;

public final class Configs
implements AutoCloseable {
    private static final Logger log = LogManager.getLogger();
    private final File configsDir;
    private final Gson gson = new Gson();
    private final MVStore store;
    private final MVMap<String, String> mvMap;

    Configs(File configsDir) throws IOException {
        Files.createDirectories(configsDir.toPath(), new FileAttribute[0]);
        log.trace("Opening configs session in " + configsDir.getAbsolutePath());
        this.configsDir = Objects.requireNonNull(configsDir, "configsDir can't be null");
        this.store = MVStore.open((String)new File(configsDir, "configs.mvdb").getAbsolutePath());
        this.mvMap = this.store.openMap("main");
    }

    public synchronized <E> E load(Class<E> cl) {
        Objects.requireNonNull(cl, "cl can't be null");
        String str = (String)this.mvMap.get((Object)cl.getName());
        if (str == null || str.isEmpty()) {
            return null;
        }
        return (E)this.gson.fromJson(str, cl);
    }

    public synchronized <E> void save(E obj) {
        Objects.requireNonNull(obj, "obj can't be null");
        this.mvMap.put((Object)obj.getClass().getName(), (Object)this.gson.toJson(obj));
    }

    public synchronized <C> void update(Class<C> configClass, ConfigUpdate<C> func) {
        Objects.requireNonNull(configClass, "configClass can't be null");
        Objects.requireNonNull(func, "func can't be null");
        C conf = this.load(configClass);
        try {
            if (conf == null) {
                conf = configClass.newInstance();
            }
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        func.update(conf);
        this.save(conf);
    }

    @Override
    public synchronized void close() {
        log.trace("Closing configs session in " + this.configsDir.getAbsolutePath());
        this.store.close();
    }
}

