/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.util.Objects;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;

public class AreaLayoutHelper {
    protected final UpdateNotification notification;
    protected Area basicArea = null;
    protected AreaLayout basicLayout = null;
    protected Area additionalArea = null;
    protected Position additionalAreaPos = null;
    protected AreaLayout tempLayout = null;

    public AreaLayoutHelper(UpdateNotification notification) {
        NullCheck.notNull((Object)notification, (String)"notification");
        this.notification = notification;
    }

    public AreaLayoutHelper(UpdateNotification notification, Area basicArea) {
        NullCheck.notNull((Object)notification, (String)"notification");
        NullCheck.notNull((Object)basicArea, (String)"basicArea");
        this.notification = notification;
        this.basicArea = basicArea;
    }

    public AreaLayoutHelper(UpdateNotification notification, AreaLayout basicLayout) {
        NullCheck.notNull((Object)notification, (String)"notification");
        NullCheck.notNull((Object)basicLayout, (String)"basicLayout");
        this.notification = notification;
        this.basicLayout = basicLayout;
    }

    public void setBasicArea(Area area) {
        Objects.requireNonNull(area, "area can't be null");
        this.basicArea = area;
        this.basicLayout = null;
        this.notification.onLayoutUpdate();
    }

    public void setBasicLayout(AreaLayout layout) {
        Objects.requireNonNull(layout, "layout can't be null");
        this.basicLayout = layout;
        this.basicArea = null;
        this.notification.onLayoutUpdate();
    }

    public void clear() {
        this.basicArea = null;
        this.basicLayout = null;
        this.notification.onLayoutUpdate();
    }

    public boolean openAdditionalArea(Area area, Position pos) {
        NullCheck.notNull((Object)area, (String)"area");
        NullCheck.notNull((Object)((Object)pos), (String)"pos");
        if (this.basicLayout != null) {
            return false;
        }
        this.additionalArea = area;
        this.additionalAreaPos = pos;
        this.notification.onLayoutUpdate();
        return true;
    }

    public void closeAdditionalArea() {
        if (this.additionalArea == null) {
            return;
        }
        this.additionalArea = null;
        this.additionalAreaPos = null;
        this.notification.onLayoutUpdate();
    }

    public Area getAdditionalArea() {
        return this.additionalArea;
    }

    public boolean hasAdditionalArea() {
        return this.additionalArea != null && this.additionalAreaPos != null;
    }

    public void openTempArea(Area area) {
        NullCheck.notNull((Object)area, (String)"area");
        this.tempLayout = new AreaLayout(area);
        this.notification.onLayoutUpdate();
    }

    public void openTempLayout(AreaLayout layout) {
        NullCheck.notNull((Object)layout, (String)"layout");
        this.tempLayout = layout;
        this.notification.onLayoutUpdate();
    }

    public void closeTempLayout() {
        if (this.tempLayout == null) {
            return;
        }
        this.tempLayout = null;
        this.notification.onLayoutUpdate();
    }

    public AreaLayout getTempLayout() {
        return this.tempLayout;
    }

    public AreaLayout getLayout() {
        if (this.tempLayout != null) {
            return this.tempLayout;
        }
        if (this.basicLayout != null) {
            return this.basicLayout;
        }
        if (this.basicArea == null) {
            return null;
        }
        if (this.additionalArea == null || this.additionalAreaPos == null) {
            return new AreaLayout(this.basicArea);
        }
        switch (this.additionalAreaPos) {
            case RIGHT: {
                return new AreaLayout(AreaLayout.LEFT_RIGHT, this.basicArea, this.additionalArea);
            }
            case LEFT: {
                return new AreaLayout(AreaLayout.LEFT_RIGHT, this.additionalArea, this.basicArea);
            }
            case TOP: {
                return new AreaLayout(AreaLayout.TOP_BOTTOM, this.additionalArea, this.basicArea);
            }
            case BOTTOM: {
                return new AreaLayout(AreaLayout.TOP_BOTTOM, this.basicArea, this.additionalArea);
            }
        }
        return null;
    }

    public static boolean activateNextArea(Luwrain luwrain, AreaLayout layout, Area activeArea) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)layout, (String)"layout");
        NullCheck.notNull((Object)activeArea, (String)"activeArea");
        Area area = layout.getNextArea(activeArea);
        if (area == null) {
            return false;
        }
        luwrain.setActiveArea(area);
        return true;
    }

    public static boolean activatePrevArea(Luwrain luwrain, AreaLayout layout, Area activeArea) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)layout, (String)"layout");
        NullCheck.notNull((Object)activeArea, (String)"activeArea");
        Area area = layout.getPrevArea(activeArea);
        if (area == null) {
            return false;
        }
        luwrain.setActiveArea(area);
        return true;
    }

    public static enum Position {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }

    public static interface UpdateNotification {
        public void onLayoutUpdate();
    }
}

