/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.edit;

import java.util.Arrays;
import org.luwrain.controls.edit.MultilineCorrector;
import org.luwrain.controls.edit.MultilineEdit;
import org.luwrain.controls.edit.MultilineEditCorrector;
import org.luwrain.controls.edit.MultilineTranslator;
import org.luwrain.controls.edit.TextEditAction;
import org.luwrain.core.HotPointControl;
import org.luwrain.core.MutableLines;
import org.luwrain.core.NullCheck;

public class LegacyMultilineTranslator
implements MultilineEditCorrector {
    protected final MultilineTranslator translator;
    protected final MutableLines lines;
    protected final HotPointControl hotPoint;
    protected String tabSeq = "\t";

    public LegacyMultilineTranslator(MultilineTranslator translator) {
        NullCheck.notNull((Object)translator, (String)"translator");
        this.translator = translator;
        this.lines = translator.lines;
        this.hotPoint = translator.hotPoint;
    }

    @Override
    public MultilineEdit.ModificationResult deleteChar(int pos, int line) {
        MultilineCorrector.DeleteCharChange c = new MultilineCorrector.DeleteCharChange(line, pos);
        this.translator.change(c);
        return c.getResult();
    }

    @Override
    public MultilineEdit.ModificationResult deleteRegion(int fromX, int fromY, int toX, int toY) {
        MultilineCorrector.DeleteFragmentChange c = new MultilineCorrector.DeleteFragmentChange(fromY, fromX, toY, toX);
        this.translator.change(c);
        return c.getResult();
    }

    @Override
    public MultilineEdit.ModificationResult insertRegion(int x, int y, String[] text) {
        MultilineCorrector.InsertFragmentChange c = new MultilineCorrector.InsertFragmentChange(y, x, Arrays.asList(text));
        this.translator.change(c);
        return c.getResult();
    }

    @Override
    public MultilineEdit.ModificationResult putChars(int pos, int line, String str) {
        MultilineCorrector.InsertCharsChange c = new MultilineCorrector.InsertCharsChange(line, pos, str);
        this.translator.change(c);
        return c.getResult();
    }

    @Override
    public MultilineEdit.ModificationResult mergeLines(int firstLineIndex) {
        MultilineCorrector.MergeLinesChange c = new MultilineCorrector.MergeLinesChange(firstLineIndex);
        this.translator.change(c);
        return c.getResult();
    }

    @Override
    public MultilineEdit.ModificationResult splitLine(int pos, int line) {
        MultilineCorrector.SplitLineChange c = new MultilineCorrector.SplitLineChange(line, pos);
        this.translator.change(c);
        return c.getResult();
    }

    @Override
    public MultilineEdit.ModificationResult doEditAction(TextEditAction action) {
        action.doTextEdit(this.lines, this.hotPoint);
        return new MultilineEdit.ModificationResult(true);
    }

    public boolean commit() {
        return true;
    }

    @Override
    public int getLineCount() {
        int count = this.lines.getLineCount();
        return count > 0 ? count : 1;
    }

    @Override
    public String getLine(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index (" + index + ") may not be negative");
        }
        if (index == 0 && this.lines.getLineCount() == 0) {
            return "";
        }
        return this.lines.getLine(index);
    }

    @Override
    public int getHotPointX() {
        return this.hotPoint.getHotPointX();
    }

    @Override
    public int getHotPointY() {
        return this.hotPoint.getHotPointY();
    }

    @Override
    public String getTabSeq() {
        return this.tabSeq;
    }
}

