/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.console;

import java.util.Objects;
import org.luwrain.controls.ConsoleArea;

public class ArrayModel<E>
implements ConsoleArea.Model<E> {
    protected final Source<E> source;

    public ArrayModel(Source<E> source) {
        this.source = Objects.requireNonNull(source, "source can't be null");
    }

    @Override
    public int getItemCount() {
        E[] o = this.source.getItems();
        return o != null ? o.length : 0;
    }

    @Override
    public E getItem(int index) {
        E[] o = this.source.getItems();
        if (o == null) {
            throw new IllegalStateException("No items");
        }
        if (index < 0 || index >= o.length) {
            throw new IllegalArgumentException("Illegal index: " + String.valueOf(index));
        }
        return o[index];
    }

    public static interface Source<E> {
        public E[] getItems();
    }
}

