/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.Suggestions;
import org.luwrain.core.events.InputEvent;

public class TreeListArea<E>
extends ListArea<E>
implements ListArea.ClickHandler<E> {
    protected final Model<E> model;
    protected List<Frame<E>> history = new ArrayList<Frame<E>>();
    protected final List<E> content;
    protected LeafClickHandler leafClickHandler = null;

    public TreeListArea(Params<E> params) {
        super(TreeListArea.createListParams(params));
        NullCheck.notNull(params.model, (String)"params.model");
        this.model = params.model;
        this.leafClickHandler = params.leafClickHandler;
        this.content = ((ModelImpl)this.getListModel()).getSource();
        this.setListClickHandler(this);
    }

    public void setLeafClickHandler(LeafClickHandler leafClickHandler) {
        NullCheck.notNull((Object)leafClickHandler, (String)"leafClickHandler");
        this.leafClickHandler = leafClickHandler;
    }

    public boolean requery() {
        if (this.history.isEmpty()) {
            this.history.add(new Frame<E>(this.model.getRoot()));
        }
        return this.fill(this.getLastFrame().parent);
    }

    public void clear() {
        this.history.clear();
        this.content.clear();
        this.reset(false);
        this.refresh();
    }

    public E opened() {
        if (this.history.isEmpty()) {
            return null;
        }
        return this.getLastFrame().parent;
    }

    protected boolean fill(E obj, E select) {
        return this.model.getItems(obj, items -> {
            if (items == null) {
                throw new NullPointerException("items can't be null");
            }
            this.content.clear();
            this.content.addAll(items);
            this.reset(false);
            this.refresh();
            if (select != null) {
                this.select(select, false);
            }
        });
    }

    protected boolean fill(E obj) {
        return this.fill(obj, null);
    }

    protected boolean fill(Frame<E> frame) {
        return this.fill(frame.parent, frame.selected);
    }

    @Override
    public boolean onListClick(ListArea<E> area, int index, E item) {
        if (!this.model.isLeaf(item)) {
            this.getLastFrame().selected = this.selected();
            this.history.add(new Frame<E>(item));
            return this.fill(item);
        }
        if (this.leafClickHandler != null) {
            return this.leafClickHandler.onLeafClick(this, item);
        }
        return false;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.isSpecial() && !event.isModified()) {
            switch (event.getSpecial()) {
                case BACKSPACE: {
                    return this.onBackspace(event);
                }
            }
        }
        return super.onInputEvent(event);
    }

    protected boolean onBackspace(InputEvent event) {
        if (this.history.size() <= 1) {
            return false;
        }
        this.history.remove(this.history.size() - 1);
        return this.fill(this.getLastFrame());
    }

    protected Frame<E> getLastFrame() {
        if (this.history.isEmpty()) {
            throw new IllegalStateException("No frames in the history");
        }
        return this.history.get(this.history.size() - 1);
    }

    protected static <E> ListArea.Params<E> createListParams(final Params params) {
        NullCheck.notNull((Object)params, (String)"params");
        NullCheck.notNull(params.model, (String)"params.model");
        ListArea.Params res = new ListArea.Params();
        res.context = params.context;
        res.name = params.name;
        res.model = new ModelImpl(new ArrayList());
        res.appearance = new Appearance<E>(res.context){

            @Override
            public boolean isLeaf(E e) {
                return params.model.isLeaf(e);
            }
        };
        return res;
    }

    public static final class Params<E> {
        public ControlContext context;
        public String name;
        public Model<E> model = null;
        public LeafClickHandler leafClickHandler = null;
    }

    public static interface LeafClickHandler<E> {
        public boolean onLeafClick(TreeListArea<E> var1, E var2);
    }

    public static interface Model<E> {
        public E getRoot();

        public boolean getItems(E var1, Collector<E> var2);

        public boolean isLeaf(E var1);
    }

    protected static class ModelImpl<E>
    extends ListUtils.ListModel<E> {
        public ModelImpl(List<E> source) {
            super(source);
        }

        public List<E> getSource() {
            return this.source;
        }
    }

    protected static final class Frame<E> {
        public final E parent;
        E selected = null;

        public Frame(E parent) {
            NullCheck.notNull(parent, (String)"parent");
            this.parent = parent;
        }
    }

    public static interface Collector<E> {
        public void collect(List<E> var1);
    }

    protected static abstract class Appearance<E>
    extends ListUtils.DefaultAppearance<E> {
        Appearance(ControlContext context) {
            super(context);
        }

        public abstract boolean isLeaf(E var1);

        @Override
        public void announceItem(E e, Set<ListArea.Appearance.Flags> flags) {
            if (!this.isLeaf(e)) {
                this.context.setEventResponse(DefaultEventResponse.listItem(Sounds.ATTENTION, e.toString(), Suggestions.CLICKABLE_LIST_ITEM));
            } else {
                this.context.setEventResponse(DefaultEventResponse.listItem(e.toString(), Suggestions.LIST_ITEM));
            }
        }
    }
}

