/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.List;
import java.util.Objects;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.MutableLinesImpl;
import org.luwrain.controls.NavigationArea;
import org.luwrain.core.MutableLines;
import org.luwrain.core.NullCheck;

public class SimpleArea
extends NavigationArea
implements MutableLines {
    protected final ControlContext environment;
    protected String name = "";
    protected final MutableLinesImpl content = new MutableLinesImpl();

    public SimpleArea(ControlContext environment) {
        super(environment);
        this.environment = environment;
        NullCheck.notNull((Object)environment, (String)"environment");
    }

    public SimpleArea(ControlContext environment, String name) {
        super(environment);
        this.environment = environment;
        this.name = name;
        NullCheck.notNull((Object)environment, (String)"environment");
        NullCheck.notNull((Object)name, (String)"name");
    }

    public SimpleArea(ControlContext environment, String name, String[] lines) {
        super(environment);
        this.environment = environment;
        this.name = name;
        NullCheck.notNull((Object)environment, (String)"environment");
        NullCheck.notNull((Object)name, (String)"name");
        NullCheck.notNullItems((Object[])lines, (String)"lines");
        this.content.setLines(lines);
    }

    @Override
    public void update(MutableLines.Updating updating) {
        NullCheck.notNull((Object)updating, (String)"updating");
        this.content.update(updating);
        this.afterChange();
    }

    @Override
    public int getLineCount() {
        int value = this.content.getLineCount();
        return value > 0 ? value : 1;
    }

    @Override
    public String getLine(int index) {
        if (index >= this.content.getLineCount()) {
            return "";
        }
        String line = this.content.getLine(index);
        return line != null ? line : "";
    }

    @Override
    public void setLines(String[] lines) {
        NullCheck.notNullItems((Object[])lines, (String)"lines");
        this.content.setLines(lines);
        this.afterChange();
    }

    @Override
    public String[] getLinesAsArray() {
        return this.content.getLinesAsArray();
    }

    @Override
    public List<String> getLines() {
        return this.content.getLines();
    }

    @Override
    public void setLine(int index, String line) {
        Objects.requireNonNull(line, "line can't be null");
        this.content.setLine(index, line);
        this.afterChange();
    }

    @Override
    public boolean add(String line) {
        Objects.requireNonNull(line, "line can't be null");
        this.content.add(line);
        this.afterChange();
        return true;
    }

    @Override
    public void add(int index, String line) {
        Objects.requireNonNull(line, "line can't be null");
        this.content.add(index, line);
        this.afterChange();
    }

    @Override
    public void removeLine(int index) {
        this.content.removeLine(index);
        this.afterChange();
    }

    @Override
    public void clear() {
        this.content.clear();
        this.afterChange();
    }

    @Override
    public String getAreaName() {
        return this.name;
    }

    public void setName(String name) {
        NullCheck.notNull((Object)name, (String)"name");
        this.name = name;
        this.environment.onAreaNewName(this);
    }

    public String getWholeText() {
        return this.content.getWholeText();
    }

    private void afterChange() {
        this.environment.onAreaNewContent(this);
    }
}

