/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.EnumSet;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.controls.AbstractRegionPoint;
import org.luwrain.controls.ClipboardTranslator;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.LinesClipboardProvider;
import org.luwrain.controls.LinesRegionTextQueryProvider;
import org.luwrain.controls.RegionPoint;
import org.luwrain.controls.RegionTextQueryTranslator;
import org.luwrain.core.Action;
import org.luwrain.core.Area;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Hint;
import org.luwrain.core.HotPointControl;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.MoveHotPointEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.i18n.LangStatic;
import org.luwrain.util.WordIterator;

public abstract class NavigationArea
implements Area,
HotPointControl,
ClipboardTranslator.Provider,
RegionTextQueryTranslator.Provider {
    private static final Logger log = LogManager.getLogger();
    protected final ControlContext context;
    protected final RegionPoint regionPoint = new RegionPoint();
    protected final ClipboardTranslator clipboardTranslator = new ClipboardTranslator(this, this.regionPoint, EnumSet.noneOf(ClipboardTranslator.Flags.class));
    protected final RegionTextQueryTranslator regionTextQueryTranslator = new RegionTextQueryTranslator(this, this.regionPoint, EnumSet.noneOf(RegionTextQueryTranslator.Flags.class));
    protected int hotPointX = 0;
    protected int hotPointY = 0;
    protected int hotPointTransCount = 0;

    public NavigationArea(ControlContext context) {
        NullCheck.notNull((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (!event.isSpecial() || event.isModified()) {
            return false;
        }
        switch (event.getSpecial()) {
            case HOME: {
                return this.onHome(event);
            }
            case END: {
                return this.onEnd(event);
            }
            case ALTERNATIVE_HOME: {
                return this.onAltHome(event);
            }
            case ALTERNATIVE_END: {
                return this.onAltEnd(event);
            }
            case ARROW_DOWN: {
                return this.onMoveDown(event);
            }
            case ARROW_UP: {
                return this.onMoveUp(event);
            }
            case ARROW_RIGHT: {
                return this.onMoveRight(event);
            }
            case ARROW_LEFT: {
                return this.onMoveLeft(event);
            }
            case ALTERNATIVE_ARROW_RIGHT: {
                return this.onAltRight(event);
            }
            case ALTERNATIVE_ARROW_LEFT: {
                return this.onAltLeft(event);
            }
            case PAGE_DOWN: {
                return this.onPageDown(event);
            }
            case PAGE_UP: {
                return this.onPageUp(event);
            }
        }
        return false;
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return false;
        }
        switch (event.getCode()) {
            case MOVE_HOT_POINT: {
                if (event instanceof MoveHotPointEvent) {
                    MoveHotPointEvent moveHotPoint = (MoveHotPointEvent)event;
                    this.setHotPoint(moveHotPoint.getNewHotPointX(), moveHotPoint.getNewHotPointY());
                    return true;
                }
                return false;
            }
        }
        if (this.clipboardTranslator.onSystemEvent(event, this.hotPointX, this.hotPointY)) {
            return true;
        }
        return this.regionTextQueryTranslator.onSystemEvent(event, this.hotPointX, this.hotPointY);
    }

    @Override
    public boolean onAreaQuery(AreaQuery query) {
        NullCheck.notNull((Object)query, (String)"query");
        return this.regionTextQueryTranslator.onAreaQuery(query, this.hotPointX, this.hotPointY);
    }

    @Override
    public Action[] getAreaActions() {
        return new Action[0];
    }

    protected boolean onHome(InputEvent event) {
        int count = this.getValidLineCount();
        this.hotPointY = this.hotPointY < count ? this.hotPointY : count - 1;
        String line = this.getLineNotNull(this.hotPointY);
        if (line.isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return true;
        }
        if (this.hotPointX > 0) {
            this.hotPointX = 0;
            this.context.onAreaNewHotPoint(this);
        }
        this.context.setEventResponse(DefaultEventResponse.letter(line.charAt(0)));
        return true;
    }

    protected boolean onEnd(InputEvent event) {
        int count = this.getValidLineCount();
        this.hotPointY = this.hotPointY < count ? this.hotPointY : count - 1;
        String line = this.getLineNotNull(this.hotPointY);
        if (line.isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return true;
        }
        if (this.hotPointX < line.length()) {
            this.hotPointX = line.length();
            this.context.onAreaNewHotPoint(this);
        }
        this.context.setEventResponse(DefaultEventResponse.hint(Hint.LINE_BOUND));
        return true;
    }

    protected boolean onAltHome(InputEvent event) {
        if (this.hotPointX >= 1 || this.hotPointY >= 1) {
            this.hotPointX = 0;
            this.hotPointY = 0;
            this.context.onAreaNewHotPoint(this);
        }
        this.context.setEventResponse(DefaultEventResponse.hint(Hint.BEGIN_OF_TEXT));
        return true;
    }

    protected boolean onAltEnd(InputEvent event) {
        int count = this.getValidLineCount();
        this.hotPointY = this.hotPointY < count ? this.hotPointY : count - 1;
        String line = this.getLineNotNull(this.hotPointY);
        int n = this.hotPointX = this.hotPointX <= line.length() ? this.hotPointX : line.length();
        if (this.hotPointY + 1 < count || this.hotPointX < line.length()) {
            String lastLine = this.getLineNotNull(count - 1);
            this.hotPointX = lastLine.length();
            this.hotPointY = count - 1;
            this.context.onAreaNewHotPoint(this);
        }
        this.context.setEventResponse(DefaultEventResponse.hint(Hint.END_OF_TEXT));
        return true;
    }

    protected boolean onMoveDown(InputEvent event) {
        int count = this.getValidLineCount();
        int n = this.hotPointY = this.hotPointY < count ? this.hotPointY : count - 1;
        if (this.hotPointY + 1 >= count) {
            if (count == 1) {
                this.context.setEventResponse(DefaultEventResponse.hint(Hint.NO_LINES_BELOW, this.context.staticStr(LangStatic.NO_LINES_BELOW) + " " + this.getLineNotNull(0)));
            } else {
                this.context.setEventResponse(DefaultEventResponse.hint(Hint.NO_LINES_BELOW));
            }
            return true;
        }
        String line = this.getLineNotNull(this.hotPointY);
        ++this.hotPointY;
        String nextLine = this.getLineNotNull(this.hotPointY);
        this.hotPointX = this.getNewHotPointX(this.hotPointY - 1, this.hotPointY, this.hotPointX, line, nextLine);
        this.context.onAreaNewHotPoint(this);
        this.announceLine(this.hotPointY, nextLine);
        return true;
    }

    protected boolean onMoveUp(InputEvent event) {
        int count = this.getValidLineCount();
        int n = this.hotPointY = this.hotPointY < count ? this.hotPointY : count - 1;
        if (this.hotPointY == 0) {
            if (count == 1) {
                this.context.setEventResponse(DefaultEventResponse.hint(Hint.NO_LINES_ABOVE, this.context.staticStr(LangStatic.NO_LINES_ABOVE) + " " + this.getLineNotNull(0)));
            } else {
                this.context.setEventResponse(DefaultEventResponse.hint(Hint.NO_LINES_ABOVE));
            }
            return true;
        }
        String line = this.getLineNotNull(this.hotPointY);
        --this.hotPointY;
        String prevLine = this.getLineNotNull(this.hotPointY);
        this.hotPointX = this.getNewHotPointX(this.hotPointY + 1, this.hotPointY, this.hotPointX, line, prevLine);
        this.context.onAreaNewHotPoint(this);
        this.announceLine(this.hotPointY, prevLine);
        return true;
    }

    protected boolean onMoveRight(InputEvent event) {
        int count = this.getValidLineCount();
        this.hotPointY = this.hotPointY < count ? this.hotPointY : count - 1;
        String line = this.getLineNotNull(this.hotPointY);
        int n = this.hotPointX = this.hotPointX <= line.length() ? this.hotPointX : line.length();
        if (this.hotPointX == line.length()) {
            if (this.hotPointY + 1 >= count) {
                this.context.setEventResponse(DefaultEventResponse.hint(Hint.END_OF_TEXT));
                return true;
            }
            ++this.hotPointY;
            this.hotPointX = 0;
        } else {
            ++this.hotPointX;
        }
        this.context.onAreaNewHotPoint(this);
        String newLine = this.getLineNotNull(this.hotPointY);
        if (this.hotPointX == newLine.length()) {
            this.context.setEventResponse(DefaultEventResponse.hint(this.hotPointY + 1 >= count ? Hint.LINE_BOUND : Hint.LINE_BOUND));
        } else {
            this.context.setEventResponse(DefaultEventResponse.letter(newLine.charAt(this.hotPointX)));
        }
        return true;
    }

    protected boolean onMoveLeft(InputEvent event) {
        String newLine;
        int count = this.getValidLineCount();
        this.hotPointY = this.hotPointY < count ? this.hotPointY : count - 1;
        String line = this.getLineNotNull(this.hotPointY);
        int n = this.hotPointX = this.hotPointX <= line.length() ? this.hotPointX : line.length();
        if (this.hotPointX == 0) {
            if (this.hotPointY == 0) {
                this.context.setEventResponse(DefaultEventResponse.hint(Hint.BEGIN_OF_TEXT));
                return true;
            }
            --this.hotPointY;
            newLine = this.getLineNotNull(this.hotPointY);
            this.hotPointX = newLine.length();
        } else {
            --this.hotPointX;
        }
        this.context.onAreaNewHotPoint(this);
        newLine = this.getLineNotNull(this.hotPointY);
        if (this.hotPointX == newLine.length()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.LINE_BOUND));
        } else {
            this.context.setEventResponse(DefaultEventResponse.letter(newLine.charAt(this.hotPointX)));
        }
        return true;
    }

    protected boolean onPageDown(InputEvent event) {
        int count = this.getValidLineCount();
        this.hotPointY = Math.min(this.hotPointY, count - 1);
        if (this.hotPointY + 1 >= count) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.NO_LINES_BELOW));
            return true;
        }
        int index = Math.min(this.getNextBlockLine(this.hotPointY), count - 1);
        if (index < 0) {
            return false;
        }
        this.hotPointX = this.getNewHotPointX(this.hotPointY, index, this.hotPointX, this.getLineNotNull(this.hotPointY), this.getLineNotNull(index));
        this.hotPointY = index;
        this.context.onAreaNewHotPoint(this);
        this.announceLine(this.hotPointY, this.getLineNotNull(this.hotPointY));
        return true;
    }

    protected boolean isBlockBoundLine(int index, String line) {
        return line.trim().isEmpty();
    }

    protected int getNextBlockLine(int startFrom) {
        int index;
        int count = this.getValidLineCount();
        for (index = startFrom; index < count - 1 && !this.isBlockBoundLine(index, this.getLineNotNull(index)); ++index) {
        }
        while (index < count - 1 && this.isBlockBoundLine(index, this.getLineNotNull(index))) {
            ++index;
        }
        return index;
    }

    protected boolean onPageUp(InputEvent event) {
        int count = this.getValidLineCount();
        this.hotPointY = Math.min(this.hotPointY, count - 1);
        if (this.hotPointY == 0) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.NO_LINES_ABOVE));
            return true;
        }
        int index = Math.min(this.getPrevBlockLine(this.hotPointY), count - 1);
        if (index < 0) {
            return false;
        }
        this.hotPointX = this.getNewHotPointX(this.hotPointY, index, this.hotPointX, this.getLineNotNull(this.hotPointY), this.getLineNotNull(index));
        this.hotPointY = index;
        this.hotPointX = 0;
        this.context.onAreaNewHotPoint(this);
        this.announceLine(this.hotPointY, this.getLineNotNull(this.hotPointY));
        return true;
    }

    protected int getPrevBlockLine(int startFrom) {
        int index;
        int count = this.getValidLineCount();
        for (index = startFrom; index > 0 && !this.isBlockBoundLine(index, this.getLineNotNull(index)); --index) {
        }
        while (index > 0 && this.isBlockBoundLine(index, this.getLineNotNull(index))) {
            --index;
        }
        if (index == 0) {
            return 0;
        }
        while (index > 0 && !this.isBlockBoundLine(index, this.getLineNotNull(index))) {
            --index;
        }
        if (this.isBlockBoundLine(index, this.getLineNotNull(index))) {
            ++index;
        }
        return index;
    }

    protected boolean onAltRight(InputEvent event) {
        int count = this.getValidLineCount();
        this.hotPointY = this.hotPointY < count ? this.hotPointY : count - 1;
        String line = this.getLineNotNull(this.hotPointY);
        if (line.isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return true;
        }
        int n = this.hotPointX = this.hotPointX <= line.length() ? this.hotPointX : line.length();
        if (this.hotPointX >= line.length()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.END_OF_LINE));
            return true;
        }
        WordIterator it = new WordIterator(line, this.hotPointX);
        if (!it.stepForward()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.END_OF_LINE));
            return true;
        }
        this.hotPointX = it.pos();
        if (it.announce().length() > 0) {
            this.context.setEventResponse(DefaultEventResponse.text(it.announce()));
        } else {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.END_OF_LINE));
        }
        if (this.hotPointTransCount > 0) {
            this.context.onAreaNewHotPoint(this);
        }
        return true;
    }

    protected boolean onAltLeft(InputEvent event) {
        int count = this.getValidLineCount();
        this.hotPointY = this.hotPointY < count ? this.hotPointY : count - 1;
        String line = this.getLineNotNull(this.hotPointY);
        if (line.isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return true;
        }
        int n = this.hotPointX = this.hotPointX <= line.length() ? this.hotPointX : line.length();
        if (this.hotPointX <= 0) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.BEGIN_OF_LINE));
            return true;
        }
        WordIterator it = new WordIterator(line, this.hotPointX);
        if (!it.stepBackward()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.BEGIN_OF_LINE));
            return true;
        }
        this.hotPointX = it.pos();
        this.context.setEventResponse(DefaultEventResponse.text(it.announce()));
        if (this.hotPointTransCount > 0) {
            this.context.onAreaNewHotPoint(this);
        }
        return true;
    }

    public void announceLine(int index, String line) {
        NullCheck.notNull((Object)line, (String)"line");
        NavigationArea.defaultLineAnnouncement(this.context, index, line);
    }

    public int getNewHotPointX(int oldHotPointY, int newHotPointY, int oldHotPointX, String oldLine, String newLine) {
        return Math.min(oldHotPointX, newLine.length());
    }

    public void reset(boolean announce) {
        this.regionPoint.reset();
        this.hotPointX = 0;
        this.hotPointY = 0;
        this.hotPointTransCount = 0;
        this.context.onAreaNewHotPoint(this);
        if (announce) {
            String line = this.getLineNotNull(0);
            if (!line.isEmpty()) {
                this.announceLine(0, line);
            } else {
                this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            }
        }
    }

    public void redraw() {
        this.context.onAreaNewContent(this);
        int lineCount = this.getValidLineCount();
        if (this.hotPointY >= lineCount) {
            this.hotPointY = lineCount - 1;
            String line = this.getLineNotNull(this.hotPointY);
            if (this.hotPointX > line.length()) {
                this.hotPointX = line.length();
            }
            this.context.onAreaNewHotPoint(this);
            return;
        }
        String line = this.getLineNotNull(this.hotPointY);
        if (this.hotPointX > line.length()) {
            this.hotPointX = line.length();
            this.context.onAreaNewHotPoint(this);
        }
    }

    @Override
    public void beginHotPointTrans() {
        ++this.hotPointTransCount;
    }

    @Override
    public void endHotPointTrans() {
        if (this.hotPointTransCount == 0) {
            log.warn("Unbalanced hot point transactions");
            return;
        }
        --this.hotPointTransCount;
        if (this.hotPointTransCount == 0) {
            this.context.onAreaNewHotPoint(this);
        }
    }

    public void setHotPoint(int x, int y) {
        int count = this.getValidLineCount();
        this.hotPointY = y < 0 ? 0 : (y >= count ? count - 1 : y);
        String line = this.getLineNotNull(this.hotPointY);
        this.hotPointX = x < 0 ? 0 : (x >= line.length() ? line.length() : x);
        this.context.onAreaNewHotPoint(this);
    }

    @Override
    public void setHotPointX(int value) {
        String line = this.getLineNotNull(this.hotPointY);
        this.hotPointX = value < 0 ? 0 : (value >= line.length() ? line.length() : value);
        this.context.onAreaNewHotPoint(this);
    }

    @Override
    public void setHotPointY(int value) {
        int count = this.getValidLineCount();
        this.hotPointY = value < 0 ? 0 : (value >= count ? count - 1 : value);
        this.context.onAreaNewHotPoint(this);
    }

    @Override
    public int getHotPointX() {
        return this.hotPointX;
    }

    @Override
    public int getHotPointY() {
        return this.hotPointY;
    }

    @Override
    public String onRegionTextQuery(int fromX, int fromY, int toX, int toY) {
        return new LinesRegionTextQueryProvider(this).onRegionTextQuery(fromX, fromY, toX, toY);
    }

    @Override
    public boolean onClipboardCopyAll() {
        return new LinesClipboardProvider(this, () -> this.context.getClipboard()).onClipboardCopyAll();
    }

    @Override
    public boolean onClipboardCopy(int fromX, int fromY, int toX, int toY, boolean withDeleting) {
        return new LinesClipboardProvider(this, () -> this.context.getClipboard()).onClipboardCopy(fromX, fromY, toX, toY, withDeleting);
    }

    @Override
    public boolean onDeleteRegion(int fromX, int fromY, int toX, int toY) {
        return new LinesClipboardProvider(this, () -> this.context.getClipboard()).onDeleteRegion(fromX, fromY, toX, toY);
    }

    public AbstractRegionPoint getRegionPoint() {
        return this.regionPoint;
    }

    protected int getValidLineCount() {
        int count = this.getLineCount();
        if (count <= 0) {
            throw new RuntimeException("The area of class " + this.getClass().getName() + " tries to have the number of lines (" + count + ") less than 1");
        }
        return count;
    }

    protected String getLineNotNull(int index) {
        String line = this.getLine(index);
        return line != null ? line : "";
    }

    public static void defaultLineAnnouncement(ControlContext context, int index, String line) {
        Objects.requireNonNull(line, "line can't be null");
        if (line.isEmpty()) {
            context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return;
        }
        if (line.trim().isEmpty()) {
            context.setEventResponse(DefaultEventResponse.hint(Hint.SPACES));
            return;
        }
        context.setEventResponse(DefaultEventResponse.text(line));
    }
}

