/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.EditableListArea;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.MarkableListArea;
import org.luwrain.core.Clipboard;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.Suggestions;

public class ListUtils {

    public static class FunctionalClipboardSaver<E>
    extends DefaultClipboardSaver<E> {
        protected final Function<E, Object> objFunc;
        protected final Function<E, String> strFunc;

        public FunctionalClipboardSaver(Function<E, Object> objFunc, Function<E, String> strFunc) {
            NullCheck.notNull(objFunc, (String)"objFunc");
            NullCheck.notNull(strFunc, (String)"strFunc");
            this.objFunc = objFunc;
            this.strFunc = strFunc;
        }

        @Override
        protected Object getClipboardObj(ListArea.Appearance<E> appearance, E obj) {
            NullCheck.notNull(appearance, (String)"appearance");
            NullCheck.notNull(obj, (String)"obj");
            Object res = this.objFunc.apply(obj);
            return res != null ? res : super.getClipboardObj(appearance, obj);
        }

        @Override
        protected String getClipboardString(ListArea.Appearance<E> appearance, E obj) {
            NullCheck.notNull(appearance, (String)"appearance");
            NullCheck.notNull(obj, (String)"obj");
            String res = this.strFunc.apply(obj);
            return res != null ? res : super.getClipboardString(appearance, obj);
        }
    }

    public static class DefaultClipboardSaver<E>
    implements ListArea.ClipboardSaver<E> {
        @Override
        public boolean saveToClipboard(ListArea<E> listArea, ListArea.Model<E> model, ListArea.Appearance<E> appearance, int fromIndex, int toIndex, Clipboard clipboard) {
            NullCheck.notNull(listArea, (String)"listArea");
            NullCheck.notNull(model, (String)"model");
            NullCheck.notNull(appearance, (String)"appearance");
            NullCheck.notNull((Object)clipboard, (String)"clipboard");
            if (fromIndex < 0) {
                throw new IllegalArgumentException("fromIndex may not be negative (" + fromIndex + ")");
            }
            if (toIndex < 0) {
                throw new IllegalArgumentException("toIndex may not be negative (" + toIndex + ")");
            }
            if (fromIndex >= toIndex) {
                return false;
            }
            ArrayList<Object> res = new ArrayList<Object>();
            ArrayList<String> strRes = new ArrayList<String>();
            res.ensureCapacity(toIndex - fromIndex);
            strRes.ensureCapacity(fromIndex - toIndex);
            for (int i = fromIndex; i < toIndex; ++i) {
                E obj = model.getItem(i);
                if (obj == null) {
                    return false;
                }
                res.add(this.getClipboardObj(appearance, obj));
                strRes.add(this.getClipboardString(appearance, obj));
                if (res.get(res.size() - 1) != null && strRes.get(strRes.size() - 1) != null) continue;
                return false;
            }
            clipboard.set(res.toArray(new Object[res.size()]), strRes.toArray(new String[strRes.size()]));
            return true;
        }

        protected String getClipboardString(ListArea.Appearance<E> appearance, E obj) {
            NullCheck.notNull(appearance, (String)"appearance");
            NullCheck.notNull(obj, (String)"obj");
            return appearance.getScreenAppearance(obj, EnumSet.of(ListArea.Appearance.Flags.CLIPBOARD));
        }

        protected Object getClipboardObj(ListArea.Appearance<E> appearance, E obj) {
            NullCheck.notNull(appearance, (String)"appearance");
            NullCheck.notNull(obj, (String)"obj");
            if (obj instanceof File || obj instanceof URL || obj instanceof URI) {
                return obj;
            }
            return appearance.getScreenAppearance(obj, EnumSet.of(ListArea.Appearance.Flags.CLIPBOARD));
        }
    }

    public static class MarkableListAppearance
    implements ListArea.Appearance<Object> {
        protected final ControlContext context;
        protected final MarkableListArea.MarksInfo marksInfo;

        public MarkableListAppearance(ControlContext context, MarkableListArea.MarksInfo marksInfo) {
            NullCheck.notNull((Object)context, (String)"context");
            NullCheck.notNull((Object)marksInfo, (String)"marksInfo");
            this.context = context;
            this.marksInfo = marksInfo;
        }

        @Override
        public void announceItem(Object item, Set<ListArea.Appearance.Flags> flags) {
            NullCheck.notNull((Object)item, (String)"item");
            NullCheck.notNull(flags, (String)"flags");
            this.context.playSound(Sounds.LIST_ITEM);
            this.context.silence();
            if (flags.contains((Object)ListArea.Appearance.Flags.BRIEF)) {
                this.context.say(item.toString());
                return;
            }
            if (this.marksInfo.marked(item)) {
                this.context.say("\u041e\u0442\u043c\u0435\u0447\u0435\u043d\u043e " + item.toString());
            } else {
                this.context.say(item.toString());
            }
        }

        @Override
        public String getScreenAppearance(Object item, Set<ListArea.Appearance.Flags> flags) {
            NullCheck.notNull((Object)item, (String)"item");
            NullCheck.notNull(flags, (String)"flags");
            if (this.marksInfo.marked(item)) {
                return "* " + item.toString();
            }
            return "  " + item.toString();
        }

        @Override
        public int getObservableLeftBound(Object item) {
            if (item == null) {
                return 0;
            }
            return 2;
        }

        @Override
        public int getObservableRightBound(Object item) {
            if (item == null) {
                return 0;
            }
            return this.getScreenAppearance(item, (Set<ListArea.Appearance.Flags>)EnumSet.noneOf(ListArea.Appearance.Flags.class)).length();
        }
    }

    public static class DefaultMarksInfo
    implements MarkableListArea.MarksInfo {
        protected final Set<Object> items = new HashSet<Object>();

        @Override
        public boolean marked(Object o) {
            NullCheck.notNull((Object)o, (String)"o");
            return this.items.contains(o);
        }

        @Override
        public void mark(Object o) {
            NullCheck.notNull((Object)o, (String)"o");
            this.items.add(o);
        }

        @Override
        public void unmark(Object o) {
            NullCheck.notNull((Object)o, (String)"o");
            this.items.remove(o);
        }

        @Override
        public boolean toggleMark(Object o) {
            NullCheck.notNull((Object)o, (String)"o");
            if (this.marked(o)) {
                this.unmark(o);
                return false;
            }
            this.mark(o);
            return true;
        }

        @Override
        public void markOnly(Object[] o) {
            NullCheck.notNullItems((Object[])o, (String)"o");
            this.items.clear();
            for (Object oo : o) {
                this.items.add(oo);
            }
        }

        @Override
        public void clearMarks() {
            this.items.clear();
        }

        @Override
        public Object[] getAllMarked() {
            ArrayList<Object> res = new ArrayList<Object>();
            for (Object o : this.items) {
                res.add(o);
            }
            return res.toArray(new Object[res.size()]);
        }
    }

    public static class DefaultEditableModel<E>
    extends ArrayList<E>
    implements EditableListArea.Model<E> {
        protected final Class<E> itemClass;

        public DefaultEditableModel(Class<E> itemClass) {
            NullCheck.notNull(itemClass, (String)"itemClass");
            this.itemClass = itemClass;
        }

        public DefaultEditableModel(Class<E> itemClass, E[] items) {
            this(itemClass);
            NullCheck.notNullItems((Object[])items, (String)"items");
            this.setItems(items);
        }

        public DefaultEditableModel(Class<E> itemClass, List<E> items) {
            this(itemClass);
            this.addAll(items);
        }

        public void setItems(E[] items) {
            NullCheck.notNullItems((Object[])items, (String)"items");
            this.clear();
            this.addAll(Arrays.asList(items));
        }

        public Object[] getItems() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public boolean addToModel(int pos, Supplier<Object> supplier) {
            NullCheck.notNull(supplier, (String)"supplier");
            if (pos < 0) {
                throw new IllegalArgumentException("pos may not be negative (" + pos + ")");
            }
            Object value = supplier.get();
            if (value == null) {
                return false;
            }
            Object[] values = value instanceof Object[] ? (Object[])value : new Object[]{value};
            ArrayList<E> c = new ArrayList<E>();
            for (Object o : values) {
                if (o == null) continue;
                if (this.itemClass.isInstance(o)) {
                    c.add(this.itemClass.cast(o));
                    continue;
                }
                E e = this.adjust(o);
                if (e == null) continue;
                c.add(e);
            }
            if (c.isEmpty()) {
                return false;
            }
            this.addAll(pos, c);
            return true;
        }

        @Override
        public boolean removeFromModel(int fromIndex, int toIndex) {
            if (fromIndex < 0) {
                throw new IllegalArgumentException("fromIndex can't be negative (" + String.valueOf(fromIndex) + ")");
            }
            if (toIndex < 0) {
                throw new IllegalArgumentException("toIndex can't be negative (" + String.valueOf(toIndex) + ")");
            }
            if (fromIndex >= this.size() || toIndex > this.size()) {
                return false;
            }
            this.removeRange(fromIndex, toIndex);
            return true;
        }

        @Override
        public int getItemCount() {
            return this.size();
        }

        @Override
        public E getItem(int index) {
            return this.get(index);
        }

        @Override
        public void refresh() {
        }

        protected E adjust(Object o) {
            return null;
        }
    }

    public static class ListModel<E>
    implements ListArea.Model<E> {
        protected final List<E> source;

        public ListModel(List<E> source) {
            NullCheck.notNull(source, (String)"source");
            this.source = source;
        }

        @Override
        public int getItemCount() {
            return this.source.size();
        }

        @Override
        public E getItem(int index) {
            return this.source.get(index);
        }

        @Override
        public void refresh() {
        }
    }

    public static class ArrayModel<E>
    implements ListArea.Model<E> {
        protected final Source<E> source;

        public ArrayModel(Source<E> source) {
            NullCheck.notNull(source, (String)"source");
            this.source = source;
        }

        @Override
        public int getItemCount() {
            E[] o = this.source.getItems();
            return o != null ? o.length : 0;
        }

        @Override
        public E getItem(int index) {
            E[] o = this.source.getItems();
            return o[index];
        }

        @Override
        public void refresh() {
        }

        public static interface Source<E> {
            public E[] getItems();
        }
    }

    public static class FixedModel<E>
    extends ArrayList<E>
    implements ListArea.Model<E> {
        public FixedModel() {
        }

        public FixedModel(E[] items) {
            NullCheck.notNullItems((Object[])items, (String)"items");
            this.addAll(Arrays.asList(items));
        }

        public void setItems(E[] items) {
            NullCheck.notNullItems((Object[])items, (String)"items");
            this.clear();
            this.addAll(Arrays.asList(items));
        }

        public Object[] getItems() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public int getItemCount() {
            return this.size();
        }

        @Override
        public E getItem(int index) {
            return this.get(index);
        }

        @Override
        public void refresh() {
        }
    }

    public static abstract class DoubleLevelTransition<E>
    extends DefaultTransition {
        protected final ListArea.Model<E> model;

        public DoubleLevelTransition(ListArea.Model<E> model) {
            NullCheck.notNull(model, (String)"model");
            this.model = model;
        }

        public abstract boolean isSectionItem(E var1);

        @Override
        public ListArea.Transition.State transition(ListArea.Transition.Type type, ListArea.Transition.State fromState, int itemCount, boolean hasEmptyLineTop, boolean hasEmptyLineBottom) {
            NullCheck.notNull((Object)((Object)type), (String)"type");
            NullCheck.notNull((Object)fromState, (String)"fromState");
            switch (type) {
                case PAGE_UP: {
                    if (fromState.type == ListArea.Transition.State.Type.EMPTY_LINE_BOTTOM) {
                        for (int i = this.model.getItemCount() - 1; i >= 0; --i) {
                            if (!this.isSectionItem(this.model.getItem(i))) continue;
                            return new ListArea.Transition.State(i);
                        }
                        return new ListArea.Transition.State(ListArea.Transition.State.Type.NO_TRANSITION);
                    }
                    if (fromState.type != ListArea.Transition.State.Type.ITEM_INDEX) {
                        return new ListArea.Transition.State(ListArea.Transition.State.Type.NO_TRANSITION);
                    }
                    for (int i = fromState.itemIndex - 1; i >= 0; --i) {
                        if (!this.isSectionItem(this.model.getItem(i))) continue;
                        return new ListArea.Transition.State(i);
                    }
                    return new ListArea.Transition.State(ListArea.Transition.State.Type.NO_TRANSITION);
                }
                case PAGE_DOWN: {
                    if (fromState.type == ListArea.Transition.State.Type.EMPTY_LINE_TOP) {
                        for (int i = 0; i < this.model.getItemCount(); ++i) {
                            if (!this.isSectionItem(this.model.getItem(i))) continue;
                            return new ListArea.Transition.State(i);
                        }
                        return new ListArea.Transition.State(ListArea.Transition.State.Type.NO_TRANSITION);
                    }
                    if (fromState.type != ListArea.Transition.State.Type.ITEM_INDEX) {
                        return new ListArea.Transition.State(ListArea.Transition.State.Type.NO_TRANSITION);
                    }
                    for (int i = fromState.itemIndex + 1; i < this.model.getItemCount(); ++i) {
                        if (!this.isSectionItem(this.model.getItem(i))) continue;
                        return new ListArea.Transition.State(i);
                    }
                    return new ListArea.Transition.State(ListArea.Transition.State.Type.NO_TRANSITION);
                }
            }
            return super.transition(type, fromState, itemCount, hasEmptyLineTop, hasEmptyLineBottom);
        }
    }

    public static class DefaultTransition
    implements ListArea.Transition {
        protected static final int PAGE_SIZE = 20;

        @Override
        public ListArea.Transition.State transition(ListArea.Transition.Type type, ListArea.Transition.State fromState, int itemCount, boolean hasEmptyLineTop, boolean hasEmptyLineBottom) {
            NullCheck.notNull((Object)((Object)type), (String)"type");
            NullCheck.notNull((Object)fromState, (String)"fromState");
            if (itemCount == 0) {
                throw new IllegalArgumentException("itemCount must be positive and non-zero (itemCount=" + itemCount + ")");
            }
            switch (type) {
                case SINGLE_DOWN: {
                    if (fromState.type == ListArea.Transition.State.Type.EMPTY_LINE_TOP) {
                        return new ListArea.Transition.State(0);
                    }
                    if (fromState.type == ListArea.Transition.State.Type.EMPTY_LINE_BOTTOM) {
                        return new ListArea.Transition.State(ListArea.Transition.State.Type.NO_TRANSITION);
                    }
                    if (fromState.type != ListArea.Transition.State.Type.ITEM_INDEX) {
                        return new ListArea.Transition.State(ListArea.Transition.State.Type.NO_TRANSITION);
                    }
                    if (fromState.itemIndex + 1 < itemCount) {
                        return new ListArea.Transition.State(fromState.itemIndex + 1);
                    }
                    return new ListArea.Transition.State(hasEmptyLineBottom ? ListArea.Transition.State.Type.EMPTY_LINE_BOTTOM : ListArea.Transition.State.Type.NO_TRANSITION);
                }
                case SINGLE_UP: {
                    if (fromState.type == ListArea.Transition.State.Type.EMPTY_LINE_BOTTOM) {
                        return new ListArea.Transition.State(itemCount - 1);
                    }
                    if (fromState.type == ListArea.Transition.State.Type.EMPTY_LINE_TOP) {
                        return new ListArea.Transition.State(ListArea.Transition.State.Type.NO_TRANSITION);
                    }
                    if (fromState.type != ListArea.Transition.State.Type.ITEM_INDEX) {
                        return new ListArea.Transition.State(ListArea.Transition.State.Type.NO_TRANSITION);
                    }
                    if (fromState.itemIndex > 0) {
                        return new ListArea.Transition.State(fromState.itemIndex - 1);
                    }
                    return new ListArea.Transition.State(hasEmptyLineTop ? ListArea.Transition.State.Type.EMPTY_LINE_TOP : ListArea.Transition.State.Type.NO_TRANSITION);
                }
                case PAGE_DOWN: {
                    if (fromState.type == ListArea.Transition.State.Type.EMPTY_LINE_TOP) {
                        return new ListArea.Transition.State(Math.min(20, itemCount - 1));
                    }
                    if (fromState.type == ListArea.Transition.State.Type.EMPTY_LINE_BOTTOM) {
                        return new ListArea.Transition.State(ListArea.Transition.State.Type.NO_TRANSITION);
                    }
                    if (fromState.type != ListArea.Transition.State.Type.ITEM_INDEX) {
                        return new ListArea.Transition.State(ListArea.Transition.State.Type.NO_TRANSITION);
                    }
                    if (fromState.itemIndex + 20 < itemCount) {
                        return new ListArea.Transition.State(fromState.itemIndex + 20);
                    }
                    if (hasEmptyLineBottom) {
                        return new ListArea.Transition.State(ListArea.Transition.State.Type.EMPTY_LINE_BOTTOM);
                    }
                    if (fromState.itemIndex + 1 >= itemCount) {
                        return new ListArea.Transition.State(ListArea.Transition.State.Type.NO_TRANSITION);
                    }
                    return new ListArea.Transition.State(itemCount - 1);
                }
                case PAGE_UP: {
                    if (fromState.type == ListArea.Transition.State.Type.EMPTY_LINE_BOTTOM) {
                        return new ListArea.Transition.State(itemCount > 20 ? itemCount - 20 : 0);
                    }
                    if (fromState.type == ListArea.Transition.State.Type.EMPTY_LINE_TOP) {
                        return new ListArea.Transition.State(ListArea.Transition.State.Type.NO_TRANSITION);
                    }
                    if (fromState.type != ListArea.Transition.State.Type.ITEM_INDEX) {
                        return new ListArea.Transition.State(ListArea.Transition.State.Type.NO_TRANSITION);
                    }
                    if (fromState.itemIndex >= 20) {
                        return new ListArea.Transition.State(fromState.itemIndex - 20);
                    }
                    if (hasEmptyLineTop) {
                        return new ListArea.Transition.State(ListArea.Transition.State.Type.EMPTY_LINE_TOP);
                    }
                    if (fromState.itemIndex == 0) {
                        return new ListArea.Transition.State(ListArea.Transition.State.Type.NO_TRANSITION);
                    }
                    return new ListArea.Transition.State(0);
                }
                case HOME: {
                    return new ListArea.Transition.State(0);
                }
                case END: {
                    if (hasEmptyLineBottom) {
                        return new ListArea.Transition.State(ListArea.Transition.State.Type.EMPTY_LINE_BOTTOM);
                    }
                    if (fromState.type != ListArea.Transition.State.Type.ITEM_INDEX) {
                        return new ListArea.Transition.State(ListArea.Transition.State.Type.NO_TRANSITION);
                    }
                    return new ListArea.Transition.State(fromState.itemIndex - 1);
                }
            }
            throw new IllegalArgumentException("Unknown transition type: " + type.toString());
        }
    }

    public static abstract class DoubleLevelAppearance<E>
    implements ListArea.Appearance<E> {
        protected final ControlContext context;

        public DoubleLevelAppearance(ControlContext context) {
            NullCheck.notNull((Object)context, (String)"context");
            this.context = context;
        }

        public abstract boolean isSectionItem(E var1);

        public void announceNonSection(E item) {
            NullCheck.notNull(item, (String)"item");
            this.context.setEventResponse(DefaultEventResponse.listItem(this.getNonSectionScreenAppearance(item)));
        }

        public String getNonSectionScreenAppearance(E item) {
            NullCheck.notNull(item, (String)"item");
            return item.toString();
        }

        public void announceSection(E item) {
            NullCheck.notNull(item, (String)"item");
            this.context.playSound(Sounds.DOC_SECTION);
            this.context.say(this.getSectionScreenAppearance(item));
        }

        public String getSectionScreenAppearance(E item) {
            NullCheck.notNull(item, (String)"item");
            return item.toString();
        }

        @Override
        public void announceItem(E item, Set<ListArea.Appearance.Flags> flags) {
            NullCheck.notNull(item, (String)"item");
            NullCheck.notNull(flags, (String)"flags");
            if (this.isSectionItem(item)) {
                this.announceSection(item);
            } else {
                this.announceNonSection(item);
            }
        }

        @Override
        public String getScreenAppearance(E item, Set<ListArea.Appearance.Flags> flags) {
            NullCheck.notNull(item, (String)"item");
            NullCheck.notNull(flags, (String)"flags");
            if (this.isSectionItem(item)) {
                return this.getSectionScreenAppearance(item);
            }
            return "  " + this.getNonSectionScreenAppearance(item);
        }

        @Override
        public int getObservableLeftBound(E item) {
            NullCheck.notNull(item, (String)"item");
            if (this.isSectionItem(item)) {
                return 0;
            }
            return 2;
        }

        @Override
        public int getObservableRightBound(E item) {
            NullCheck.notNull(item, (String)"item");
            return this.getScreenAppearance(item, EnumSet.noneOf(ListArea.Appearance.Flags.class)).length();
        }
    }

    public static class DefaultAppearance<E>
    extends AbstractAppearance<E> {
        protected final ControlContext context;
        protected final Suggestions suggestion;

        public DefaultAppearance(ControlContext context, Suggestions suggestion) {
            NullCheck.notNull((Object)context, (String)"context");
            this.context = context;
            this.suggestion = suggestion;
        }

        public DefaultAppearance(ControlContext context) {
            NullCheck.notNull((Object)context, (String)"context");
            this.context = context;
            this.suggestion = Suggestions.LIST_ITEM;
        }

        @Override
        public void announceItem(E item, Set<ListArea.Appearance.Flags> flags) {
            NullCheck.notNull(item, (String)"item");
            NullCheck.notNull(flags, (String)"flags");
            this.context.setEventResponse(DefaultEventResponse.listItem(item.toString(), flags.contains((Object)ListArea.Appearance.Flags.BRIEF) ? null : this.suggestion));
        }
    }

    public static abstract class AbstractAppearance<E>
    implements ListArea.Appearance<E> {
        @Override
        public String getScreenAppearance(E item, Set<ListArea.Appearance.Flags> flags) {
            NullCheck.notNull(item, (String)"item");
            NullCheck.notNull(flags, (String)"flags");
            return item.toString();
        }

        @Override
        public int getObservableLeftBound(E item) {
            return 0;
        }

        @Override
        public int getObservableRightBound(E item) {
            NullCheck.notNull(item, (String)"item");
            return this.getScreenAppearance(item, EnumSet.noneOf(ListArea.Appearance.Flags.class)).length();
        }
    }
}

