/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.EmbeddedEdit;
import org.luwrain.controls.EmbeddedEditLines;
import org.luwrain.controls.HotPointShift;
import org.luwrain.controls.MutableMarkedLinesImpl;
import org.luwrain.controls.NavigationArea;
import org.luwrain.controls.WrappingControlContext;
import org.luwrain.controls.edit.DefaultMultilineEditAppearance;
import org.luwrain.controls.edit.MultilineEdit;
import org.luwrain.controls.edit.MultilineEditModelChangeListener;
import org.luwrain.controls.edit.MultilineEditTranslator;
import org.luwrain.core.Area;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Event;
import org.luwrain.core.HotPoint;
import org.luwrain.core.HotPointControl;
import org.luwrain.core.Luwrain;
import org.luwrain.core.MarkedLines;
import org.luwrain.core.MutableLines;
import org.luwrain.core.MutableMarkedLines;
import org.luwrain.core.NullCheck;
import org.luwrain.core.UniRefInfo;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;

public class FormArea
extends NavigationArea {
    protected final ControlContext context;
    protected final List<Item> items = new ArrayList<Item>();
    protected String name = "";
    protected int nextAutoNameNum = 1;
    protected MutableMarkedLines mlEditContent = null;
    protected MultilineEdit mlEdit = null;
    protected List<MultilineEditChangeListener> mlEditChangeListeners = new ArrayList<MultilineEditChangeListener>();
    protected final HotPointShift mlEditHotPoint = new HotPointShift(this, 0, 0);
    protected String multilineEditCaption = "";
    protected boolean multilineEditEnabled = true;

    public FormArea(ControlContext context) {
        super(context);
        Objects.requireNonNull(context, "context can't be null");
        this.context = context;
        this.name = "";
    }

    public FormArea(ControlContext context, String name) {
        super(context);
        Objects.requireNonNull(context, "context can't be null");
        Objects.requireNonNull(name, "name can't be null");
        this.context = context;
        this.name = name;
    }

    public FormArea(ControlContext context, String name, int textLenLimit) {
        super(context);
        Objects.requireNonNull(context, "context can't be null");
        Objects.requireNonNull(name, "nam ecan't be null");
        this.context = context;
        this.name = name;
    }

    public void clear() {
        this.nextAutoNameNum = 1;
        this.items.clear();
        this.multilineEditCaption = "";
        this.mlEdit = null;
        this.multilineEditEnabled = true;
        this.context.onAreaNewContent(this);
        this.setHotPoint(0, 0);
    }

    public boolean hasItemWithName(String itemName) {
        NullCheck.notNull((Object)itemName, (String)"itemName");
        if (itemName.isEmpty()) {
            return false;
        }
        for (Item i : this.items) {
            if (!i.name.equals(itemName)) continue;
            return true;
        }
        return false;
    }

    public String getItemNewAutoName() {
        return "form-auto-name-" + this.nextAutoNameNum++;
    }

    public Type getItemTypeOnLine(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index may not be negative");
        }
        if (index < this.items.size()) {
            return this.items.get((int)index).type;
        }
        return this.isMultilineEditActivated() ? Type.MULTILINE : null;
    }

    public int getItemCount() {
        return this.items.size();
    }

    public String getItemNameOnLine(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index may not be negative");
        }
        if (index >= this.items.size()) {
            return null;
        }
        return this.items.get((int)index).name;
    }

    public Object getItemObj(int index) {
        if (index < 0 || index >= this.items.size()) {
            throw new IllegalArgumentException("index (" + String.valueOf(index) + ") is out of bounds");
        }
        return this.items.get((int)index).obj;
    }

    public Object getItemObjByName(String itemName) {
        NullCheck.notEmpty((Object)itemName, (String)"itemName");
        for (Item i : this.items) {
            if (!i.name.equals(itemName)) continue;
            return i.obj;
        }
        return null;
    }

    public boolean addEdit(String itemName, String caption) {
        NullCheck.notEmpty((Object)itemName, (String)"itemName");
        Objects.requireNonNull(caption, "caption can't be null");
        return this.addEdit(itemName, caption, "");
    }

    public boolean addEdit(String itemName, String caption, String initialText) {
        NullCheck.notEmpty((Object)itemName, (String)"itemName");
        Objects.requireNonNull(caption, "caption can't be null");
        Objects.requireNonNull(initialText, "initialText can't be null");
        return this.addEdit(itemName, caption, initialText, null, true);
    }

    public boolean addEdit(String itemName, String caption, String initialText, Object obj, boolean enabled) {
        NullCheck.notEmpty((Object)itemName, (String)"itemName");
        Objects.requireNonNull(caption, "caption can't be null");
        Objects.requireNonNull(initialText, "initialText can't be null");
        Item item = new Item(this.context, this, Type.EDIT, itemName);
        item.caption = caption;
        item.enteredText = initialText;
        item.obj = obj;
        item.enabled = enabled;
        item.edit = new EmbeddedEdit(this.context, item, this, this.regionPoint, item.caption.length(), this.items.size());
        this.items.add(item);
        this.updateItems();
        this.context.onAreaNewContent(this);
        this.context.onAreaNewHotPoint(this);
        return true;
    }

    public boolean addPasswd(String name, String caption, String text, Object obj, boolean enabled) {
        Objects.requireNonNull(name, "name can't be null");
        Objects.requireNonNull(caption, "caption can't be null");
        Objects.requireNonNull(text, "tex tcan't be null");
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name can't be empty");
        }
        Item item = new Item(this.context, this, Type.EDIT, name);
        item.caption = caption;
        item.enteredText = text;
        item.obj = obj;
        item.enabled = enabled;
        item.hideLetters = true;
        item.edit = new EmbeddedEdit(new WrappingControlContext(this.context){

            @Override
            public void sayLetter(char letter) {
                super.sayLetter('*');
            }
        }, item, this, this.regionPoint, item.caption.length(), this.items.size());
        this.items.add(item);
        this.updateItems();
        this.context.onAreaNewContent(this);
        this.context.onAreaNewHotPoint(this);
        return true;
    }

    public void setEnteredText(String itemName, String newText) {
        NullCheck.notNull((Object)itemName, (String)"itemName");
        NullCheck.notNull((Object)newText, (String)"newText");
        if (itemName.trim().isEmpty()) {
            return;
        }
        for (Item i : this.items) {
            if (i.type != Type.EDIT || !i.name.equals(itemName)) continue;
            i.enteredText = newText;
        }
        this.context.onAreaNewContent(this);
    }

    public String getEnteredText(String itemName) {
        NullCheck.notEmpty((Object)itemName, (String)"itemName");
        for (Item i : this.items) {
            if (i.type != Type.EDIT || !i.name.equals(itemName)) continue;
            return i.enteredText;
        }
        return null;
    }

    public String getEnteredText(int lineIndex) {
        if (lineIndex < 0 || lineIndex > this.items.size()) {
            return null;
        }
        Item i = this.items.get(lineIndex);
        if (i.type == Type.EDIT) {
            return i.enteredText;
        }
        return null;
    }

    public boolean addList(String itemName, String caption, Object initialSelectedItem, ListChoosing listChoosing, Object obj, boolean enabled) {
        NullCheck.notNull((Object)itemName, (String)"itemName");
        Objects.requireNonNull(caption, "caption can't be null");
        NullCheck.notNull((Object)listChoosing, (String)"listChoosing");
        if (itemName.trim().isEmpty() || this.hasItemWithName(itemName)) {
            return false;
        }
        Item item = new Item(this.context, this, Type.LIST, itemName);
        item.caption = caption;
        item.selectedListItem = initialSelectedItem;
        item.listChoosing = listChoosing;
        item.obj = obj;
        item.enabled = enabled;
        this.items.add(item);
        this.updateItems();
        this.context.onAreaNewContent(this);
        this.context.onAreaNewHotPoint(this);
        return true;
    }

    public Object getSelectedListItem(String itemName) {
        NullCheck.notNull((Object)itemName, (String)"itemName");
        if (itemName.trim().isEmpty()) {
            return null;
        }
        for (Item i : this.items) {
            if (i.type != Type.LIST || !i.name.equals(itemName)) continue;
            return i.selectedListItem;
        }
        return null;
    }

    public boolean addCheckbox(String itemName, String caption, boolean initialState, Object obj, boolean enabled) {
        NullCheck.notNull((Object)itemName, (String)"itemName");
        Objects.requireNonNull(caption, "caption can't be null");
        if (itemName.trim().isEmpty() || this.hasItemWithName(itemName)) {
            return false;
        }
        Item item = new Item(this.context, this, Type.CHECKBOX, itemName);
        item.caption = caption;
        item.checkboxState = initialState;
        item.obj = obj;
        item.enabled = enabled;
        this.items.add(item);
        this.updateItems();
        this.context.onAreaNewContent(this);
        this.context.onAreaNewHotPoint(this);
        return true;
    }

    public boolean addCheckbox(String itemName, String caption, boolean initialState) {
        NullCheck.notNull((Object)itemName, (String)"itemName");
        Objects.requireNonNull(caption, "caption can't be null");
        return this.addCheckbox(itemName, caption, initialState, null, true);
    }

    public boolean getCheckboxState(String itemName) {
        NullCheck.notNull((Object)itemName, (String)"itemName");
        if (itemName.trim().isEmpty()) {
            return false;
        }
        for (Item i : this.items) {
            if (i.type != Type.CHECKBOX || !i.name.equals(itemName)) continue;
            return i.checkboxState;
        }
        return false;
    }

    public boolean addStatic(String itemName, String caption, Object obj) {
        NullCheck.notEmpty((Object)itemName, (String)"itemName");
        Objects.requireNonNull(caption, "caption can't be null");
        if (this.hasItemWithName(itemName)) {
            return false;
        }
        Item item = new Item(this.context, this, Type.STATIC, itemName);
        item.caption = caption;
        item.obj = obj;
        this.items.add(item);
        this.updateItems();
        this.context.onAreaNewContent(this);
        this.context.onAreaNewHotPoint(this);
        return true;
    }

    public boolean addStatic(String itemName, String caption) {
        NullCheck.notNull((Object)itemName, (String)"itemName");
        Objects.requireNonNull(caption, "caption can't be null");
        return this.addStatic(itemName, caption, "");
    }

    public boolean addStatic(String caption) {
        Objects.requireNonNull(caption, "caption can't be null");
        return this.addStatic(this.getItemNewAutoName(), caption, "");
    }

    public boolean isMultilineEditActivated() {
        return this.mlEdit != null;
    }

    public boolean isMultilineEditEnabled() {
        return this.isMultilineEditActivated() && this.multilineEditEnabled;
    }

    public boolean multilineEditHasCaption() {
        return this.multilineEditCaption != null && !this.multilineEditCaption.isEmpty();
    }

    public MultilineEdit.Params createMultilineEditParams(final ControlContext context, MutableLines lines) {
        Objects.requireNonNull(context, "context can't be null");
        Objects.requireNonNull(lines, "lines can't be null");
        MultilineEdit.Params params = new MultilineEdit.Params();
        params.context = context;
        params.model = new MultilineEditModelChangeListener(new MultilineEditTranslator(lines, this.mlEditHotPoint)){

            @Override
            public void onAfterMultilineEditChange() {
                context.onAreaNewContent(FormArea.this);
                context.onAreaNewHotPoint(FormArea.this);
            }
        };
        params.appearance = new DefaultMultilineEditAppearance(context);
        params.regionPoint = this.regionPoint;
        return params;
    }

    public boolean activateMultilineEdit(String caption, MutableMarkedLines content, MultilineEdit.Params params, boolean enabled) {
        Objects.requireNonNull(caption, "caption can't be null");
        NullCheck.notNull((Object)content, (String)"content");
        NullCheck.notNull((Object)params, (String)"params");
        if (this.isMultilineEditActivated()) {
            return false;
        }
        this.multilineEditCaption = caption;
        this.mlEditContent = content;
        this.mlEdit = new MultilineEdit(params);
        this.multilineEditEnabled = enabled;
        this.updateItems();
        this.context.onAreaNewContent(this);
        this.context.onAreaNewHotPoint(this);
        return true;
    }

    public boolean addMultilineEdit(String caption, List<String> text, boolean enabled) {
        Objects.requireNonNull(caption, "caption can't be null");
        Objects.requireNonNull(text, "text can't be null");
        return this.activateMultilineEdit(caption, text.toArray(new String[text.size()]), enabled);
    }

    public boolean activateMultilineEdit(String caption, String[] text, boolean enabled) {
        Objects.requireNonNull(caption, "caption can't be null");
        NullCheck.notNullItems((Object[])text, (String)"text");
        MutableMarkedLinesImpl content = new MutableMarkedLinesImpl(text);
        MultilineEdit.Params params = this.createMultilineEditParams(this.context, content);
        return this.activateMultilineEdit(caption, content, params, enabled);
    }

    public boolean activateMultilineEdit(String caption, String[] text) {
        Objects.requireNonNull(caption, "caption can't be null");
        NullCheck.notNullItems((Object[])text, (String)"text");
        return this.activateMultilineEdit(caption, text, true);
    }

    public boolean updateMultilineEdit(MultilineEditUpdating updating) {
        NullCheck.notNull((Object)updating, (String)"updating");
        if (this.mlEditContent == null) {
            throw new IllegalStateException("Multiline edit not activated");
        }
        if (!updating.editUpdate(this.mlEditContent, this.mlEditHotPoint)) {
            this.redraw();
            return false;
        }
        this.redraw();
        this.notifyChangeListeners(null);
        return true;
    }

    public HotPoint getMultilineEditHotPoint() {
        return this.mlEditHotPoint;
    }

    public boolean isHotPointInMultilineEdit() {
        return this.isPointInMultilineEdit(this.getHotPointX(), this.getHotPointY());
    }

    public boolean isPointInMultilineEdit(int x, int y) {
        if (x < 0) {
            throw new IllegalArgumentException("x can't be negative");
        }
        if (y < 0) {
            throw new IllegalArgumentException("y can't be negative");
        }
        return x >= this.mlEditHotPoint.getOffsetX() && y >= this.mlEditHotPoint.getOffsetY();
    }

    public String getMultilineEditText(String lineSeparator) {
        NullCheck.notNull((Object)lineSeparator, (String)"lineSeparator");
        if (this.mlEditContent == null) {
            return null;
        }
        int count = this.mlEditContent.getLineCount();
        if (count == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append(this.mlEditContent.getLine(0));
        for (int i = 1; i < count; ++i) {
            b.append(lineSeparator).append(this.mlEditContent.getLine(i));
        }
        return new String(b);
    }

    public String[] getMultilineEditText() {
        return this.mlEditContent != null ? this.mlEditContent.getLinesAsArray() : new String[]{};
    }

    public MutableMarkedLines getMultilineEditContent() {
        return this.mlEditContent;
    }

    public boolean removeItemOnLine(int index) {
        if (index < 0 || index >= this.items.size()) {
            return false;
        }
        this.items.remove(index);
        this.updateItems();
        this.context.onAreaNewContent(this);
        this.context.onAreaNewHotPoint(this);
        return true;
    }

    public boolean removeItemByName(String itemName) {
        NullCheck.notNull((Object)itemName, (String)"itemName");
        if (itemName.trim().isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get((int)i).name.equals(itemName)) continue;
            this.items.remove(i);
            this.updateItems();
            this.context.onAreaNewContent(this);
            this.context.onAreaNewHotPoint(this);
            return true;
        }
        return false;
    }

    public List<MultilineEditChangeListener> getMultilineEditChangeListeners() {
        return this.mlEditChangeListeners;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        int index;
        if (event.isSpecial() && event.getSpecial() == InputEvent.Special.DELETE && !event.isModified() && (index = this.getHotPointY()) >= 0 && index < this.items.size() && this.items.get((int)index).type == Type.UNIREF) {
            this.items.get((int)index).uniRefInfo = null;
            this.context.onAreaNewContent(this);
            return true;
        }
        if (event.isSpecial() && event.getSpecial() == InputEvent.Special.ENTER && !event.isModified()) {
            if (this.getHotPointY() < this.items.size() && this.items.get((int)this.getHotPointY()).type == Type.LIST) {
                Item item = this.items.get(this.getHotPointY());
                Object newSelectedItem = item.listChoosing.chooseFormListItem(this, item.name, item.selectedListItem);
                if (newSelectedItem == null) {
                    return true;
                }
                item.selectedListItem = newSelectedItem;
                this.context.onAreaNewContent(this);
                this.context.onAreaNewHotPoint(this);
                return true;
            }
            if (this.getHotPointY() < this.items.size() && this.items.get((int)this.getHotPointY()).type == Type.CHECKBOX) {
                Item item = this.items.get(this.getHotPointY());
                if (item.checkboxState) {
                    item.checkboxState = false;
                    this.context.setEventResponse(DefaultEventResponse.text(this.context.getStaticStr("No")));
                } else {
                    item.checkboxState = true;
                    this.context.setEventResponse(DefaultEventResponse.text(this.context.getStaticStr("Yes")));
                }
                this.context.onAreaNewContent(this);
                this.context.onAreaNewHotPoint(this);
                return true;
            }
        }
        if (!event.isSpecial() && this.getHotPointY() < this.items.size()) {
            index = this.getHotPointY();
            Item item = this.items.get(index);
            if (item.type == Type.EDIT && this.getHotPointX() < item.caption.length()) {
                this.setHotPointX(item.caption.length() + item.enteredText.length());
            }
        }
        for (Item i : this.items) {
            if (i.type != Type.EDIT || i.edit == null || !i.enabled || !i.edit.isPosCovered(this.getHotPointX(), this.getHotPointY()) || !i.onInputEvent(event)) continue;
            return true;
        }
        if (this.isMultilineEditEnabled() && this.isHotPointInMultilineEdit() && this.mlEdit.onInputEvent(event)) {
            this.notifyChangeListeners(event);
            return true;
        }
        return super.onInputEvent(event);
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return super.onSystemEvent(event);
        }
        for (Item i : this.items) {
            if (!i.isEnabledEdit() || !i.edit.isPosCovered(this.getHotPointX(), this.getHotPointY()) || !i.onSystemEvent(event)) continue;
            return true;
        }
        if (this.isMultilineEditEnabled() && this.isHotPointInMultilineEdit() && this.mlEdit.onSystemEvent(event)) {
            this.notifyChangeListeners(event);
            return true;
        }
        return super.onSystemEvent(event);
    }

    @Override
    public boolean onAreaQuery(AreaQuery query) {
        NullCheck.notNull((Object)query, (String)"query");
        for (Item i : this.items) {
            if (!i.isEnabledEdit() || !i.edit.isPosCovered(this.getHotPointX(), this.getHotPointY()) || !i.onAreaQuery(query)) continue;
            return true;
        }
        if (this.isMultilineEditEnabled() && this.isHotPointInMultilineEdit() && this.mlEdit.onAreaQuery(query)) {
            return true;
        }
        return super.onAreaQuery(query);
    }

    @Override
    public int getLineCount() {
        int res = this.items.size();
        if (!this.isMultilineEditActivated()) {
            return res + 1;
        }
        int count = this.mlEditContent.getLineCount();
        res += count;
        if (count == 0) {
            ++res;
        }
        if (this.multilineEditHasCaption()) {
            ++res;
        }
        return res;
    }

    @Override
    public String getLine(int index) {
        if (index < 0) {
            return "";
        }
        if (index < this.items.size()) {
            Item item = this.items.get(index);
            switch (item.type) {
                case EDIT: {
                    String text;
                    if (item.hideLetters) {
                        StringBuilder b = new StringBuilder();
                        for (int i = 0; i < item.enteredText.length(); ++i) {
                            b.append("*");
                        }
                        text = new String(b);
                    } else {
                        text = item.enteredText;
                    }
                    return item.caption + text;
                }
                case UNIREF: {
                    return item.caption + (item.uniRefInfo != null ? item.uniRefInfo.toString() : "");
                }
                case LIST: {
                    return item.caption + (item.selectedListItem != null ? item.selectedListItem.toString() : "");
                }
                case CHECKBOX: {
                    return item.caption + " " + this.context.getStaticStr(item.checkboxState ? "Yes" : "No");
                }
                case STATIC: {
                    return item.caption;
                }
            }
            return "FIXME";
        }
        if (!this.isMultilineEditActivated()) {
            return "";
        }
        int pos = index - this.items.size();
        if (this.multilineEditHasCaption()) {
            if (pos == 0) {
                return this.multilineEditCaption;
            }
            if (pos < this.mlEditContent.getLineCount() + 1) {
                return this.mlEditContent.getLine(pos - 1);
            }
            return "";
        }
        if (pos < this.mlEditContent.getLineCount()) {
            return this.mlEditContent.getLine(pos);
        }
        return "";
    }

    @Override
    public void announceLine(int index, String line) {
        Type type = this.getItemTypeOnLine(index);
        if (type == Type.STATIC) {
            FormArea.defaultLineAnnouncement(this.context, index, this.context.getSpeakableText(line, Luwrain.SpeakableTextType.NATURAL));
            return;
        }
        FormArea.defaultLineAnnouncement(this.context, index, this.context.getSpeakableText(line, Luwrain.SpeakableTextType.PROGRAMMING));
    }

    @Override
    public int getNewHotPointX(int oldHotPointY, int newHotPointY, int oldHotPointX, String oldLine, String newLine) {
        NullCheck.notNull((Object)oldLine, (String)"oldLine");
        NullCheck.notNull((Object)newLine, (String)"newLine");
        if (newHotPointY == this.items.size()) {
            return 0;
        }
        if (newHotPointY < this.items.size()) {
            switch (this.items.get((int)newHotPointY).type) {
                case EDIT: {
                    return newLine.length();
                }
            }
            return 0;
        }
        return super.getNewHotPointX(oldHotPointY, newHotPointY, oldHotPointX, oldLine, newLine);
    }

    @Override
    public String getAreaName() {
        return this.name;
    }

    public void setAreaName(String name) {
        NullCheck.notNull((Object)name, (String)"name");
        this.name = name;
    }

    protected Item findItemByIndex(int index) {
        if (index < 0 || index >= this.items.size()) {
            return null;
        }
        return this.items.get(index);
    }

    protected Item findItemByName(String itemName) {
        NullCheck.notEmpty((Object)itemName, (String)"itemName");
        for (Item i : this.items) {
            if (!i.name.equals(itemName)) continue;
            return i;
        }
        return null;
    }

    protected void updateItems() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get((int)i).type != Type.EDIT) continue;
            Item item = this.items.get(i);
            item.edit.setNewOffset(item.caption.length(), i);
        }
        if (!this.isMultilineEditActivated()) {
            return;
        }
        int offset = this.items.size();
        if (this.multilineEditHasCaption()) {
            ++offset;
        }
        this.mlEditHotPoint.setOffsetY(offset);
    }

    protected void notifyChangeListeners(Event event) {
        for (MultilineEditChangeListener l : this.mlEditChangeListeners) {
            l.onEditChange(this, event, this.mlEditContent, this.mlEditHotPoint);
        }
    }

    protected final class Item
    implements EmbeddedEditLines {
        final Type type;
        final String name;
        String caption;
        Object obj;
        boolean enabled = true;
        protected final Area area;
        protected String enteredText = "";
        protected EmbeddedEdit edit = null;
        protected boolean hideLetters = false;
        UniRefInfo uniRefInfo;
        protected Object staticObject;
        protected Object selectedListItem = null;
        protected ListChoosing listChoosing;
        boolean checkboxState;

        Item(ControlContext context, Area area, Type type, String name) {
            NullCheck.notNull((Object)context, (String)"context");
            NullCheck.notNull((Object)area, (String)"area");
            NullCheck.notNull((Object)((Object)type), (String)"type");
            NullCheck.notNull((Object)name, (String)"name");
            this.area = area;
            this.type = type;
            this.name = name;
        }

        boolean onInputEvent(InputEvent event) {
            return this.edit != null ? this.edit.onInputEvent(event) : false;
        }

        boolean onSystemEvent(SystemEvent event) {
            return this.edit != null ? this.edit.onSystemEvent(event) : false;
        }

        boolean onAreaQuery(AreaQuery query) {
            return this.edit != null ? this.edit.onAreaQuery(query) : false;
        }

        boolean isEnabledEdit() {
            return this.type == Type.EDIT && this.edit != null && this.enabled;
        }

        @Override
        public String getEmbeddedEditLine(int editPosX, int editPosY) {
            return this.enteredText;
        }

        @Override
        public void setEmbeddedEditLine(int editPosX, int editPosY, String value) {
            this.enteredText = value != null ? value : "";
            FormArea.this.context.onAreaNewContent(this.area);
        }
    }

    public static enum Type {
        EDIT,
        CHECKBOX,
        LIST,
        STATIC,
        UNIREF,
        MULTILINE;

    }

    public static interface ListChoosing {
        public Object chooseFormListItem(Area var1, String var2, Object var3);
    }

    public static interface MultilineEditUpdating {
        public boolean editUpdate(MutableMarkedLines var1, HotPointControl var2);
    }

    public static interface MultilineEditChangeListener {
        public void onEditChange(FormArea var1, Event var2, MarkedLines var3, HotPoint var4);
    }
}

