/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import org.luwrain.controls.ControlContext;
import org.luwrain.controls.EmbeddedEdit;
import org.luwrain.controls.EmbeddedEditLines;
import org.luwrain.controls.NavigationArea;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Hint;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.i18n.LangStatic;

public class ConsoleArea<E>
extends NavigationArea
implements EmbeddedEditLines {
    protected String areaName = "";
    protected Model<E> consoleModel;
    protected final Appearance<E> consoleAppearance;
    protected ClickHandler<E> consoleClickHandler = null;
    protected InputHandler consoleInputHandler = null;
    protected final EmbeddedEdit edit;
    protected final InputPos inputPos;
    protected String enteringPrefix = "";
    protected String enteringText = "";

    public ConsoleArea(Params<E> params) {
        super(params.context);
        NullCheck.notNull(params, (String)"params");
        NullCheck.notNull(params.model, (String)"params.model");
        NullCheck.notNull(params.appearance, (String)"params.appearance");
        NullCheck.notNull((Object)params.name, (String)"params.name");
        NullCheck.notNull((Object)((Object)params.inputPos), (String)"params.inputPos");
        NullCheck.notNull((Object)params.inputPrefix, (String)"params.inputPrefix");
        this.inputPos = params.inputPos;
        this.consoleModel = params.model;
        this.consoleAppearance = params.appearance;
        this.consoleClickHandler = params.clickHandler;
        this.consoleInputHandler = params.inputHandler;
        this.enteringPrefix = params.inputPrefix;
        this.areaName = params.name;
        this.edit = new EmbeddedEdit(this.context, this, this, this.regionPoint, 0, 0);
        this.refresh();
        this.moveHotPointToInput();
    }

    public void setConsoleClickHandler(ClickHandler<E> clickHandler) {
        this.consoleClickHandler = clickHandler;
    }

    public void setConsoleInputHandler(InputHandler inputHandler) {
        this.consoleInputHandler = inputHandler;
    }

    public void moveHotPointToInput() {
        this.setHotPoint(this.enteringPrefix.length(), this.getEnteringLineIndex());
    }

    public void setInputPrefix(String prefix) {
        NullCheck.notNull((Object)prefix, (String)"prefix");
        this.enteringPrefix = prefix;
        this.refresh();
    }

    public void setInput(String value) {
        NullCheck.notNull((Object)value, (String)"value");
        this.enteringText = value;
        this.refresh();
    }

    public void refresh() {
        this.edit.setNewOffset(this.enteringPrefix.length(), this.getEnteringLineIndex());
        this.context.onAreaNewContent(this);
        if (this.getHotPointY() >= this.getLineCount()) {
            this.setHotPointY(this.getLineCount() - 1);
        }
        String line = this.getLine(this.getHotPointY());
        if (this.getHotPointX() > line.length()) {
            this.setHotPointX(line.length());
        }
    }

    public int getSelectedIndex() {
        return this.getExistingItemIndexOnLine(this.getHotPointY());
    }

    public E selected() {
        int index = this.getSelectedIndex();
        return index >= 0 ? (E)this.consoleModel.getItem(index) : null;
    }

    public int getExistingItemIndexOnLine(int lineIndex) {
        if (lineIndex < 0) {
            throw new IllegalArgumentException("lineIndex may not be negative (" + lineIndex + ")");
        }
        switch (this.inputPos) {
            case TOP: {
                if (lineIndex == 0) {
                    return -1;
                }
                if (lineIndex - 1 < this.consoleModel.getItemCount()) {
                    return lineIndex - 1;
                }
                return -1;
            }
            case BOTTOM: {
                if (lineIndex < this.consoleModel.getItemCount()) {
                    return lineIndex;
                }
                return -1;
            }
        }
        return -1;
    }

    @Override
    protected boolean onAltHome(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.inputPos != InputPos.TOP) {
            return super.onAltHome(event);
        }
        this.moveHotPointToInput();
        if (this.enteringText.isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
        } else if (this.enteringText.trim().isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.SPACES));
        } else {
            this.context.setEventResponse(DefaultEventResponse.text(this.enteringText));
        }
        return true;
    }

    @Override
    protected boolean onAltEnd(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.inputPos != InputPos.BOTTOM) {
            return super.onAltEnd(event);
        }
        this.moveHotPointToInput();
        if (this.enteringText.isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
        } else if (this.enteringText.trim().isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.SPACES));
        } else {
            this.context.setEventResponse(DefaultEventResponse.text(this.enteringText));
        }
        return true;
    }

    @Override
    public int getLineCount() {
        return this.consoleModel.getItemCount() + 2;
    }

    @Override
    public String getLine(int index) {
        if (index < 0 || index >= this.consoleModel.getItemCount() + 1) {
            return "";
        }
        switch (this.inputPos) {
            case TOP: {
                if (index == 0) {
                    return this.enteringPrefix + this.enteringText;
                }
                if (index - 1 < this.consoleModel.getItemCount()) {
                    return this.consoleAppearance.getTextAppearance(this.consoleModel.getItem(index - 1));
                }
                return "";
            }
            case BOTTOM: {
                if (index < this.consoleModel.getItemCount()) {
                    return this.consoleAppearance.getTextAppearance(this.consoleModel.getItem(index));
                }
                if (index == this.consoleModel.getItemCount()) {
                    return this.enteringPrefix + this.enteringText;
                }
                return "";
            }
        }
        return "";
    }

    @Override
    public String getAreaName() {
        return this.areaName;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (!this.edit.isPosCovered(this.getHotPointX(), this.getHotPointY()) && !event.isSpecial()) {
            this.setHotPoint(this.enteringPrefix.length() + this.enteringText.length(), this.getEnteringLineIndex());
        }
        if (this.edit.isPosCovered(this.getHotPointX(), this.getHotPointY())) {
            if (event.isSpecial() && !event.isModified()) {
                switch (event.getSpecial()) {
                    case ENTER: {
                        return this.onEnterInEdit();
                    }
                }
            }
            if (this.edit.onInputEvent(event)) {
                return true;
            }
        }
        if (event.isSpecial() && !event.isModified()) {
            switch (event.getSpecial()) {
                case ENTER: {
                    int index = this.getExistingItemIndexOnLine(this.getHotPointY());
                    if (index < 0) break;
                    if (this.consoleClickHandler == null) {
                        return false;
                    }
                    return this.consoleClickHandler.onConsoleClick(this, index, this.consoleModel.getItem(index));
                }
            }
        }
        return super.onInputEvent(event);
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return super.onSystemEvent(event);
        }
        if (this.edit.isPosCovered(this.getHotPointX(), this.getHotPointY()) && this.edit.onSystemEvent(event)) {
            return true;
        }
        switch (event.getCode()) {
            case OK: {
                if (this.edit.isPosCovered(this.getHotPointX(), this.getHotPointY())) {
                    return this.onEnterInEdit();
                }
                return false;
            }
        }
        return super.onSystemEvent(event);
    }

    @Override
    public boolean onAreaQuery(AreaQuery query) {
        NullCheck.notNull((Object)query, (String)"query");
        if (this.edit.isPosCovered(this.getHotPointX(), this.getHotPointY()) && this.edit.onAreaQuery(query)) {
            return true;
        }
        return super.onAreaQuery(query);
    }

    @Override
    protected boolean onMoveDown(InputEvent event) {
        int count = this.getValidLineCount();
        int n = this.hotPointY = this.hotPointY < count ? this.hotPointY : count - 1;
        if (this.hotPointY + 1 >= count) {
            if (count == 1) {
                this.context.setEventResponse(DefaultEventResponse.hint(Hint.NO_LINES_BELOW, this.context.staticStr(LangStatic.NO_LINES_BELOW) + " " + this.getLineNotNull(0)));
            } else {
                this.context.setEventResponse(DefaultEventResponse.hint(Hint.NO_LINES_BELOW));
            }
            return true;
        }
        ++this.hotPointY;
        String nextLine = this.getLineNotNull(this.hotPointY);
        this.hotPointX = 0;
        this.context.onAreaNewHotPoint(this);
        this.announceLine(this.hotPointY, nextLine);
        return true;
    }

    @Override
    protected boolean onMoveUp(InputEvent event) {
        int count = this.getValidLineCount();
        int n = this.hotPointY = this.hotPointY < count ? this.hotPointY : count - 1;
        if (this.hotPointY == 0) {
            if (count == 1) {
                this.context.setEventResponse(DefaultEventResponse.hint(Hint.NO_LINES_ABOVE, this.context.staticStr(LangStatic.NO_LINES_ABOVE) + " " + this.getLineNotNull(0)));
            } else {
                this.context.setEventResponse(DefaultEventResponse.hint(Hint.NO_LINES_ABOVE));
            }
            return true;
        }
        --this.hotPointY;
        String prevLine = this.getLineNotNull(this.hotPointY);
        this.hotPointX = 0;
        this.context.onAreaNewHotPoint(this);
        this.announceLine(this.hotPointY, prevLine);
        return true;
    }

    @Override
    public void setEmbeddedEditLine(int x, int y, String line) {
        NullCheck.notNull((Object)line, (String)"line");
        this.enteringText = line;
        this.refresh();
    }

    @Override
    public String getEmbeddedEditLine(int x, int y) {
        return this.enteringText;
    }

    @Override
    public void announceLine(int index, String line) {
        NullCheck.notNull((Object)line, (String)"line");
        switch (this.inputPos) {
            case BOTTOM: {
                if (index < this.consoleModel.getItemCount()) {
                    this.consoleAppearance.announceItem(this.consoleModel.getItem(index));
                    return;
                }
                if (!line.isEmpty()) {
                    this.context.say(line);
                } else {
                    this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
                }
                return;
            }
            case TOP: {
                if (index > 0 && index - 1 < this.consoleModel.getItemCount()) {
                    this.consoleAppearance.announceItem(this.consoleModel.getItem(index - 1));
                    return;
                }
                if (!line.isEmpty()) {
                    this.context.say(line);
                } else {
                    this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
                }
                return;
            }
        }
    }

    protected int getEnteringLineIndex() {
        switch (this.inputPos) {
            case BOTTOM: {
                return this.consoleModel.getItemCount();
            }
            case TOP: {
                return 0;
            }
        }
        return 0;
    }

    protected boolean onEnterInEdit() {
        if (this.consoleInputHandler == null || this.enteringText.isEmpty()) {
            return false;
        }
        InputHandler.Result res = this.consoleInputHandler.onConsoleInput(this, this.enteringText);
        if (res == null) {
            return false;
        }
        switch (res) {
            case REJECTED: {
                return false;
            }
            case CLEAR_INPUT: {
                this.enteringText = "";
            }
        }
        this.refresh();
        return true;
    }

    public static class Params<E> {
        public ControlContext context = null;
        public String name = "";
        public Model<E> model = null;
        public Appearance<E> appearance = null;
        public ClickHandler<E> clickHandler = null;
        public InputHandler inputHandler = null;
        public InputPos inputPos = InputPos.TOP;
        public String inputPrefix = ">";
    }

    public static interface ClickHandler<E> {
        public boolean onConsoleClick(ConsoleArea var1, int var2, E var3);
    }

    public static interface InputHandler {
        public Result onConsoleInput(ConsoleArea var1, String var2);

        public static enum Result {
            REJECTED,
            OK,
            CLEAR_INPUT;

        }
    }

    public static interface Model<E> {
        public int getItemCount();

        public E getItem(int var1);
    }

    public static interface Appearance<E> {
        public void announceItem(E var1);

        public String getTextAppearance(E var1);
    }

    public static enum InputPos {
        TOP,
        BOTTOM;

    }
}

