/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.Set;
import org.luwrain.controls.AbstractRegionPoint;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.SystemEvent;

public class ClipboardTranslator {
    protected final Provider provider;
    protected final AbstractRegionPoint regionPoint;
    protected final Set<Flags> flags;

    public ClipboardTranslator(Provider provider, AbstractRegionPoint regionPoint, Set<Flags> flags) {
        NullCheck.notNull((Object)provider, (String)"provider");
        NullCheck.notNull((Object)regionPoint, (String)"regionPoint");
        NullCheck.notNull(flags, (String)"flags");
        this.provider = provider;
        this.regionPoint = regionPoint;
        this.flags = flags;
    }

    public boolean onSystemEvent(SystemEvent event, int hotPointX, int hotPointY) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return false;
        }
        if (hotPointX < 0 || hotPointY < 0) {
            throw new IllegalArgumentException("hotPointX and hotPointY must be greater or equal to zero (" + hotPointX + "," + hotPointY + ")");
        }
        switch (event.getCode()) {
            case REGION_POINT: {
                return this.regionPoint.onSystemEvent(event, hotPointX, hotPointY);
            }
            case CLIPBOARD_COPY: {
                return this.onCopy(hotPointX, hotPointY, false);
            }
            case CLIPBOARD_CUT: {
                return this.onCopy(hotPointX, hotPointY, true);
            }
            case CLIPBOARD_COPY_ALL: {
                return this.provider.onClipboardCopyAll();
            }
            case CLEAR_REGION: {
                return this.onDelete(hotPointX, hotPointY);
            }
        }
        return false;
    }

    protected boolean onCopy(int hotPointX, int hotPointY, boolean withDeleting) {
        int y2;
        int x2;
        int y1;
        int x1;
        if (!this.regionPoint.isInitialized()) {
            if (!this.flags.contains((Object)Flags.ALLOWED_WITHOUT_REGION_POINT)) {
                return false;
            }
            return this.provider.onClipboardCopy(-1, -1, hotPointX, hotPointY, withDeleting);
        }
        if (this.regionPoint.getHotPointY() < hotPointY) {
            x1 = this.regionPoint.getHotPointX();
            y1 = this.regionPoint.getHotPointY();
            x2 = hotPointX;
            y2 = hotPointY;
        } else if (this.regionPoint.getHotPointY() > hotPointY) {
            x1 = hotPointX;
            y1 = hotPointY;
            x2 = this.regionPoint.getHotPointX();
            y2 = this.regionPoint.getHotPointY();
        } else if (this.regionPoint.getHotPointX() <= hotPointX) {
            x1 = this.regionPoint.getHotPointX();
            y1 = this.regionPoint.getHotPointY();
            x2 = hotPointX;
            y2 = hotPointY;
        } else {
            x1 = hotPointX;
            y1 = hotPointY;
            x2 = this.regionPoint.getHotPointX();
            y2 = this.regionPoint.getHotPointY();
        }
        if (x1 == x2 && y1 == y2 && !this.flags.contains((Object)Flags.ALLOWED_EMPTY)) {
            return false;
        }
        return this.provider.onClipboardCopy(x1, y1, x2, y2, withDeleting);
    }

    protected boolean onDelete(int hotPointX, int hotPointY) {
        int y2;
        int x2;
        int y1;
        int x1;
        if (!this.regionPoint.isInitialized()) {
            if (!this.flags.contains((Object)Flags.ALLOWED_WITHOUT_REGION_POINT)) {
                return false;
            }
            return this.provider.onDeleteRegion(-1, -1, hotPointX, hotPointY);
        }
        if (this.regionPoint.getHotPointY() < hotPointY) {
            x1 = this.regionPoint.getHotPointX();
            y1 = this.regionPoint.getHotPointY();
            x2 = hotPointX;
            y2 = hotPointY;
        } else if (this.regionPoint.getHotPointY() > hotPointY) {
            x1 = hotPointX;
            y1 = hotPointY;
            x2 = this.regionPoint.getHotPointX();
            y2 = this.regionPoint.getHotPointY();
        } else if (this.regionPoint.getHotPointX() <= hotPointX) {
            x1 = this.regionPoint.getHotPointX();
            y1 = this.regionPoint.getHotPointY();
            x2 = hotPointX;
            y2 = hotPointY;
        } else {
            x1 = hotPointX;
            y1 = hotPointY;
            x2 = this.regionPoint.getHotPointX();
            y2 = this.regionPoint.getHotPointY();
        }
        if (x1 == x2 && y1 == y2 && !this.flags.contains((Object)Flags.ALLOWED_EMPTY)) {
            return false;
        }
        return this.provider.onDeleteRegion(x1, y1, x2, y2);
    }

    public static interface Provider {
        public boolean onClipboardCopyAll();

        public boolean onClipboardCopy(int var1, int var2, int var3, int var4, boolean var5);

        public boolean onDeleteRegion(int var1, int var2, int var3, int var4);
    }

    public static enum Flags {
        ALLOWED_EMPTY,
        ALLOWED_WITHOUT_REGION_POINT;

    }
}

