/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import org.luwrain.controls.ControlContext;
import org.luwrain.core.Action;
import org.luwrain.core.Area;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;

public class CenteredArea
implements Area {
    protected final ControlContext context;
    protected String areaName = "";
    protected int screenWidth;
    protected int screenHeight;
    protected String[] lines = new String[0];
    protected int hotPointX = 0;
    protected int hotPointY = 0;

    public CenteredArea(ControlContext context) {
        NullCheck.notNull((Object)context, (String)"context");
        this.context = context;
        this.screenWidth = context.getScreenWidth();
        this.screenHeight = context.getScreenHeight();
    }

    public CenteredArea(ControlContext context, String areaName) {
        NullCheck.notNull((Object)context, (String)"context");
        NullCheck.notNull((Object)areaName, (String)"areaName");
        this.context = context;
        this.areaName = areaName;
        this.screenWidth = context.getScreenWidth();
        this.screenHeight = context.getScreenHeight();
    }

    @Override
    public int getHotPointX() {
        return this.getLeft() + this.hotPointX;
    }

    @Override
    public int getHotPointY() {
        return this.getTop() + this.hotPointY;
    }

    @Override
    public int getLineCount() {
        int res = this.getTop() + this.lines.length;
        return res > 0 ? res : 1;
    }

    @Override
    public String getLine(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index (" + index + ") may not be negative");
        }
        int top = this.getTop();
        if (index < top) {
            return "";
        }
        if (index >= top + this.lines.length) {
            return "";
        }
        int localIndex = index - top;
        int left = this.getLeft();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < left; ++i) {
            b.append(" ");
        }
        return new String(b) + this.lines[localIndex];
    }

    @Override
    public String getAreaName() {
        return this.areaName;
    }

    public void setAreaName(String newName) {
        NullCheck.notNull((Object)newName, (String)"newName");
        this.areaName = this.areaName;
        this.context.onAreaNewName(this);
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        return false;
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getCode() == SystemEvent.Code.FONT_SIZE_CHANGED) {
            this.screenWidth = this.context.getScreenWidth();
            this.screenHeight = this.context.getScreenHeight();
            this.context.onAreaNewContent(this);
            this.context.onAreaNewHotPoint(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean onAreaQuery(AreaQuery query) {
        return false;
    }

    @Override
    public Action[] getAreaActions() {
        return new Action[0];
    }

    public void setLines(String[] newLines) {
        NullCheck.notNullItems((Object[])newLines, (String)"newLines");
        this.lines = newLines;
        this.context.onAreaNewContent(this);
        this.context.onAreaNewHotPoint(this);
    }

    public String[] getLines() {
        return (String[])this.lines.clone();
    }

    public int getLocalHotPointX() {
        return this.hotPointX;
    }

    public int getLocalHotPointY() {
        return this.hotPointY;
    }

    public void setLocalHotPointX(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value (" + value + ") may not be negative");
        }
        this.hotPointX = value;
        this.context.onAreaNewHotPoint(this);
    }

    public void setLocalHotPointY(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value (" + value + ") may not be negative");
        }
        this.hotPointY = value;
        this.context.onAreaNewHotPoint(this);
    }

    public int getMaxLineLen() {
        int res = 0;
        for (String s : this.lines) {
            if (res >= s.length()) continue;
            res = s.length();
        }
        return res;
    }

    public int getLeft() {
        int res = this.screenWidth / 2 - this.getMaxLineLen() / 2;
        return res >= 0 ? res : 0;
    }

    public int getTop() {
        int res = this.screenHeight / 2 - this.lines.length / 2;
        return res >= 0 ? res : 0;
    }
}

