/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.cpanel;

import java.util.HashMap;
import java.util.LinkedList;
import org.luwrain.app.cpanel.Base;
import org.luwrain.app.cpanel.TreeItem;
import org.luwrain.controls.CachedTreeModelSource;
import org.luwrain.core.NullCheck;
import org.luwrain.cpanel.Element;
import org.luwrain.cpanel.Section;
import org.luwrain.cpanel.StandardElements;

class SectionsTreeModelSource
implements CachedTreeModelSource {
    private Base base;
    private HashMap<Element, TreeItem> treeItems;

    SectionsTreeModelSource(Base base, HashMap<Element, TreeItem> treeItems) {
        NullCheck.notNull((Object)base, (String)"base");
        NullCheck.notNull(treeItems, (String)"treeItems");
        this.base = base;
        this.treeItems = treeItems;
    }

    void setTreeItems(HashMap<Element, TreeItem> treeItems) {
        NullCheck.notNull(treeItems, (String)"treeItems");
        this.treeItems = treeItems;
    }

    @Override
    public Object getRoot() {
        return this.findSect(StandardElements.ROOT);
    }

    @Override
    public Object[] getChildObjs(Object obj) {
        NullCheck.notNull((Object)obj, (String)"obj");
        Element el = ((Section)obj).getElement();
        TreeItem item = this.treeItems.get(el);
        this.base.addOnDemandElements(item);
        if (item == null || item.children.isEmpty()) {
            return new Section[0];
        }
        LinkedList<Section> res = new LinkedList<Section>();
        for (Element c : item.children) {
            Section sect = this.findSect(c);
            if (sect == null) continue;
            res.add(sect);
        }
        return res.toArray(new Section[res.size()]);
    }

    private Section findSect(Element el) {
        TreeItem item = this.treeItems.get(el);
        if (el == null) {
            return null;
        }
        if (item.sect != null) {
            return item.sect;
        }
        if (item.factory == null) {
            return null;
        }
        item.sect = item.factory.createSection(el);
        return item.sect;
    }
}

