/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.console;

import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.luwrain.app.console.App;
import org.luwrain.app.console.Entry;

@Plugin(name="LogAppender", category="Core", elementType="appender")
public class LogAppender
extends AbstractAppender {
    protected LogAppender(String name, Filter filter) {
        super(name, filter, null);
    }

    @PluginFactory
    public static LogAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter) {
        return new LogAppender(name, filter);
    }

    public void append(LogEvent event) {
        App.events.add(new Entry(event));
        if (!event.getLoggerName().startsWith("org.luwrain.core")) {
            return;
        }
        switch (event.getLevel().getStandardLevel()) {
            case INFO: {
                System.out.println(event.getMessage().getFormattedMessage() + " (" + event.getLoggerName() + ")");
                break;
            }
            case WARN: {
                System.out.println("WARN: " + event.getMessage().getFormattedMessage() + " (" + event.getLoggerName() + ")");
                break;
            }
            case ERROR: {
                System.out.println("ERROR: " + event.getMessage().getFormattedMessage() + " (" + event.getLoggerName() + ")");
            }
        }
    }
}

