/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.concurrent.Worker;
import javafx.scene.web.WebEngine;
import netscape.javascript.JSObject;
import org.luwrain.app.webinspector.App;
import org.luwrain.util.ResourceUtils;
import org.luwrain.web.BlockGeom;
import org.luwrain.web.WebKitBlock;
import org.luwrain.web.WebKitBlocksCollector;
import org.w3c.dom.html.HTMLBodyElement;
import org.w3c.dom.html.HTMLDocument;

public final class WebKitBlocks {
    private static final String MUTATION_OBSERVER_INJECTION = "mutation_observer_injection.js";
    private static String mutationObserverInjection = null;
    public final List<WebKitBlock> blocks = new ArrayList<WebKitBlock>();
    final WebEngine engine;
    final HTMLDocument doc;
    final HTMLBodyElement body;
    private boolean needsToBeUpdated = false;

    public WebKitBlocks(WebEngine engine) {
        this.engine = engine;
        this.doc = (HTMLDocument)engine.documentProperty().getValue();
        this.body = (HTMLBodyElement)this.doc.getBody();
        this.enableMutationObserver();
    }

    public List<WebKitBlock> process(int desiredWidth) {
        try {
            if (desiredWidth <= 0) {
                throw new IllegalArgumentException("desiredWidth (" + desiredWidth + ") must be a positive number");
            }
            this.blocks.clear();
            WebKitBlocksCollector c = new WebKitBlocksCollector(this.engine);
            c.process(this.body);
            this.blocks.addAll(c.blocks);
            int maxWidth = 0;
            for (WebKitBlock b2 : this.blocks) {
                maxWidth = Math.max(maxWidth, b2.right);
            }
            float scale = Float.valueOf(desiredWidth).floatValue() / (float)maxWidth;
            App.log("Scale is " + String.format("%.2f", Float.valueOf(scale)));
            this.blocks.parallelStream().forEach(b -> b.rescale(scale));
            App.log("Building lines");
            this.blocks.forEach(b -> b.buildLines());
            App.log("Building of lines completed");
            new BlockGeom(this.blocks).process();
            return this.blocks;
        }
        catch (Throwable e) {
            App.log("Exception: " + e.getClass().getSimpleName());
            App.log("Message: " + e.getMessage());
            return Arrays.asList(new WebKitBlock[0]);
        }
    }

    public void enableMutationObserver() {
        try {
            if (mutationObserverInjection == null) {
                mutationObserverInjection = ResourceUtils.getStringResource(this.getClass(), (String)MUTATION_OBSERVER_INJECTION);
                this.engine.getLoadWorker().stateProperty().addListener((observableValue, oldState, newState) -> {
                    if (newState == Worker.State.SUCCEEDED) {
                        JSObject jsObject = (JSObject)this.engine.executeScript("window");
                        jsObject.setMember("webKitBlocks", this);
                        this.engine.executeScript(mutationObserverInjection);
                    }
                });
            }
        }
        catch (IOException e) {
            App.log("Can not enable mutation observer injection: " + e.getMessage());
        }
        catch (NullPointerException e) {
            App.log("Can not find mutation observer injection resource mutation_observer_injection.js");
        }
    }

    public boolean isNeedsToBeUpdated() {
        return this.needsToBeUpdated;
    }

    public void setNeedsToBeUpdated(boolean needsToBeUpdated) {
        this.needsToBeUpdated = needsToBeUpdated;
    }
}

