/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.web;

import com.sun.webkit.dom.DOMWindowImpl;
import com.sun.webkit.dom.HTMLElementImpl;
import com.sun.webkit.dom.NodeImpl;
import java.util.concurrent.atomic.AtomicReference;
import org.luwrain.app.webinspector.App;
import org.luwrain.core.NullCheck;
import org.luwrain.graphical.FxThread;
import org.luwrain.web.GeomEntry;
import org.luwrain.web.WebKitBlockBase;
import org.luwrain.web.WebKitGeom;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;

public final class WebKitBlock
extends WebKitBlockBase {
    private static final int MIN_BLOCK_WIDTH = 5;
    public final String className;
    public final String tagName;
    public final int srcLeft;
    public final int srcRight;
    public final int srcTop;
    public final int srcBottom;
    public final boolean visible;
    final NodeImpl node;
    final DOMWindowImpl window;
    public String text = null;

    public WebKitBlock(DOMWindowImpl window, WebKitGeom geom, NodeImpl node) {
        NullCheck.notNull((Object)window, (String)"window");
        NullCheck.notNull((Object)geom, (String)"geom");
        NullCheck.notNull((Object)node, (String)"node");
        FxThread.ensure();
        this.window = window;
        this.node = node;
        this.className = node.getClass().getSimpleName();
        if (node instanceof HTMLElementImpl) {
            HTMLElementImpl el = (HTMLElementImpl)node;
            this.tagName = el.getTagName();
        } else {
            this.tagName = null;
        }
        GeomEntry entry = geom.getEntry((Node)node);
        if (entry != null) {
            this.srcLeft = entry.x;
            this.srcRight = entry.x + entry.width;
            this.srcTop = entry.y;
            this.srcBottom = entry.y + entry.height;
        } else {
            App.log("No geom for the node " + node.getClass().getSimpleName());
            this.srcLeft = 0;
            this.srcRight = 0;
            this.srcTop = 0;
            this.srcBottom = 0;
        }
        this.left = this.srcLeft;
        this.right = this.srcRight;
        this.top = this.srcTop;
        this.visible = this.right - this.left > 0;
    }

    public boolean isVisible() {
        return this.visible;
    }

    void rescale(float scale) {
        this.left = Float.valueOf(scale * (float)this.left).intValue();
        this.right = Math.max(Float.valueOf(scale * (float)this.right).intValue(), this.left + 5);
        this.top = Float.valueOf(scale * (float)this.top).intValue();
    }

    public String getStyle() {
        NodeImpl nodeImpl = this.node;
        if (nodeImpl instanceof Element) {
            Element el = (Element)nodeImpl;
            AtomicReference res = new AtomicReference();
            FxThread.runSync(() -> {
                CSSStyleDeclaration css = this.window.getComputedStyle(el, "");
                if (css != null) {
                    res.set(css.getCssText());
                }
            });
            return (String)res.get();
        }
        return null;
    }
}

