/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.web;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.luwrain.app.webinspector.App;

public abstract class BlocksCollector<N, B> {
    final LinkedList<B> blocksStack = new LinkedList();
    final LinkedList<N> markupStack = new LinkedList();
    final ArrayList<B> blocks = new ArrayList();

    public abstract List<N> getChildNodes(N var1);

    public abstract boolean isMarkupNode(N var1);

    public abstract boolean isTextNode(N var1);

    public abstract void addTextToBlock(N var1, B var2);

    public abstract B createBlock(N var1);

    public abstract boolean saveBlock(B var1);

    public void process(N node) {
        try {
            if (this.isTextNode(node)) {
                if (!this.blocksStack.isEmpty()) {
                    this.addTextToBlock(node, this.blocksStack.getLast());
                }
                return;
            }
            List<N> children = this.getChildNodes(node);
            if (this.isMarkupNode(node)) {
                this.markupStack.addLast(node);
                for (N c : children) {
                    this.process(c);
                }
                this.markupStack.pollLast();
                return;
            }
            this.blocksStack.addLast(this.createBlock(node));
            for (N c : children) {
                this.process(c);
            }
            B block = this.blocksStack.pollLast();
            if (this.saveBlock(block)) {
                this.blocks.add(block);
            }
        }
        catch (Throwable e) {
            App.log(e.getMessage());
        }
    }
}

